/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageTierUpgradeShapedRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public MovingStorageTierUpgradeShapedRecipe(ShapedRecipe compose) {
        super(compose.group(), compose.category(), compose.pattern, compose.result);
        this.compose = compose;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack upgradedMovingStorage = super.assemble(input, registries);
        this.getOriginalMovingStorage(input).ifPresent(originalMovingStorage -> {
            ItemStack originalStorageItem = MovingStorageItem.getStorageItem((DataComponentHolder)originalMovingStorage);
            ItemStack upgradedStorageItem = MovingStorageItem.getStorageItem((DataComponentHolder)upgradedMovingStorage);
            upgradedStorageItem.applyComponents(originalStorageItem.getComponentsPatch());
            upgradedStorageItem.set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)MovingStorageWrapper.getDefaultNumberOfInventorySlots((ItemStack)upgradedStorageItem));
            upgradedStorageItem.set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)MovingStorageWrapper.getDefaultNumberOfUpgradeSlots((ItemStack)upgradedStorageItem));
            upgradedMovingStorage.applyComponents(originalMovingStorage.getComponentsPatch());
            MovingStorageItem.setStorageItem(upgradedMovingStorage, upgradedStorageItem);
        });
        return upgradedMovingStorage;
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getOriginalMovingStorage(CraftingInput input) {
        for (int slot = 0; slot < input.size(); ++slot) {
            ItemStack slotStack = input.getItem(slot);
            if (!(slotStack.getItem() instanceof MovingStorageItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<MovingStorageTierUpgradeShapedRecipe> getSerializer() {
        return ModItems.MOVING_STORAGE_TIER_UPGRADE_SHAPED_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, MovingStorageTierUpgradeShapedRecipe> {
        public Serializer() {
            super(MovingStorageTierUpgradeShapedRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

