/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.CustomShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageTierUpgradeShapelessRecipe
extends CustomShapelessRecipe
implements IWrapperRecipe<ShapelessRecipe> {
    private final ShapelessRecipe compose;

    public MovingStorageTierUpgradeShapelessRecipe(ShapelessRecipe compose) {
        super(compose.group(), compose.category(), compose.result, compose.ingredients);
        this.compose = compose;
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack upgradedMovingStorage = super.assemble(input, registries);
        this.getOriginalMovingStorage(input).ifPresent(originalMovingStorage -> {
            ItemStack originalStorageItem = MovingStorageItem.getStorageItem((DataComponentHolder)originalMovingStorage);
            ItemStack upgradedStorageItem = MovingStorageItem.getStorageItem((DataComponentHolder)upgradedMovingStorage);
            upgradedStorageItem.applyComponents(originalStorageItem.getComponents());
            upgradedStorageItem.set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)MovingStorageWrapper.getDefaultNumberOfInventorySlots((ItemStack)upgradedStorageItem));
            upgradedStorageItem.set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)MovingStorageWrapper.getDefaultNumberOfUpgradeSlots((ItemStack)upgradedStorageItem));
            upgradedMovingStorage.applyComponents(originalMovingStorage.getComponents());
            MovingStorageItem.setStorageItem(upgradedMovingStorage, upgradedStorageItem);
        });
        return upgradedMovingStorage;
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getOriginalMovingStorage(CraftingInput input) {
        for (int slot = 0; slot < input.size(); ++slot) {
            ItemStack slotStack = input.getItem(slot);
            if (!(slotStack.getItem() instanceof MovingStorageItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<MovingStorageTierUpgradeShapelessRecipe> getSerializer() {
        return ModItems.MOVING_STORAGE_TIER_UPGRADE_SHAPELESS_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapelessRecipe, MovingStorageTierUpgradeShapelessRecipe> {
        public Serializer() {
            super(MovingStorageTierUpgradeShapelessRecipe::new, RecipeSerializer.SHAPELESS_RECIPE);
        }
    }
}

