/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ValueIOHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;

public class MovingStorageData
extends SavedData
implements IStorageSavedData {
    private static final SavedDataType<MovingStorageData> TYPE = new SavedDataType("sophisticatedstorageinmotion", MovingStorageData::new, RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)CodecHelper.STRING_ENCODED_UUID, (Codec)ContainerContents.CODEC).fieldOf("storageContents").forGetter(data -> data.movingStorageContents)).apply((Applicative)builder, MovingStorageData::new)));
    private static final MovingStorageData clientStorageCopy = new MovingStorageData();
    private final Map<UUID, ContainerContents> movingStorageContents = new HashMap<UUID, ContainerContents>();
    private final Set<UUID> updatedStorageSettingsFlags = new HashSet<UUID>();

    private MovingStorageData(Map<UUID, ContainerContents> movingStorageContents) {
        this.movingStorageContents.putAll(movingStorageContents);
    }

    private MovingStorageData() {
    }

    public static MovingStorageData get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (MovingStorageData)storage.computeIfAbsent(TYPE);
        }
        return clientStorageCopy;
    }

    public ContainerContents getContents(UUID storageId) {
        return this.movingStorageContents.computeIfAbsent(storageId, k -> new ContainerContents());
    }

    public static void moveToItemStorage(HolderLookup.Provider registries, ItemStack storageItem, UUID storageId) {
        MovingStorageData storageData = MovingStorageData.get();
        ContainerContents contents = storageData.getContents(storageId);
        RenderData renderData = ((RenderData)storageItem.getOrDefault(ModCoreDataComponents.RENDER_DATA, (Object)RenderData.EMPTY)).copy();
        CompoundTag additionalBeData = ValueIOHelper.collectOutputToTag((HolderLookup.Provider)registries, out -> out.child("storageWrapper").store("renderData", RenderData.CODEC, (Object)renderData));
        ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
        itemContentsStorage.setContents(storageId, contents);
        itemContentsStorage.setAdditionalBeData(storageId, additionalBeData);
        storageData.removeStorageContents(storageId);
    }

    public void removeStorageContents(UUID storageId) {
        this.movingStorageContents.remove(storageId);
        this.setDirty();
    }

    public void setContentsClient(UUID storageId, ContainerContents contents) {
        if (!this.movingStorageContents.containsKey(storageId)) {
            this.movingStorageContents.put(storageId, contents);
            this.updatedStorageSettingsFlags.add(storageId);
        } else {
            ContainerContents currentContents = this.movingStorageContents.get(storageId);
            ContainerContents.SettingsData previousSettings = currentContents.settings().copy();
            currentContents.reloadFrom(contents);
            if (!currentContents.settings().equals((Object)previousSettings)) {
                this.updatedStorageSettingsFlags.add(storageId);
            }
        }
    }

    public void setContents(UUID storageId, ContainerContents contents) {
        this.movingStorageContents.put(storageId, contents);
        this.setDirty();
    }

    public void markChanged() {
        this.setDirty();
    }

    public boolean removeUpdatedStorageSettingsFlag(UUID storageId) {
        return this.updatedStorageSettingsFlags.remove(storageId);
    }
}

