/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui.StorageInMotionTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;

public class StorageMinecart
extends MinecartChest
implements IMovingStorageEntity {
    private static final EntityDataAccessor<Optional<Component>> DATA_CUSTOM_NAME = SynchedEntityData.defineId(StorageMinecart.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_COMPONENT);
    static final EntityDataAccessor<ItemStack> DATA_STORAGE_ITEM = SynchedEntityData.defineId(StorageMinecart.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final EntityStorageHolder<StorageMinecart> entityStorageHolder = new EntityStorageHolder<StorageMinecart>(this);

    public StorageMinecart(EntityType<StorageMinecart> entityType, Level level) {
        super(entityType, level);
    }

    public StorageMinecart(Level level) {
        this(ModEntities.STORAGE_MINECART.get(), level);
    }

    public StorageMinecart(Level level, double x, double y, double z) {
        this(level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STORAGE_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_CUSTOM_NAME, Optional.empty());
    }

    @Override
    public ItemStack getStorageItem() {
        return (ItemStack)this.entityData.get(DATA_STORAGE_ITEM);
    }

    @Override
    public void setStorageItem(ItemStack storageItem) {
        this.entityData.set(DATA_STORAGE_ITEM, (Object)storageItem.copy());
    }

    @Override
    public EntityStorageHolder<?> getStorageHolder() {
        return this.entityStorageHolder;
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource source, float amount) {
        return this.getStorageHolder().hurt(serverLevel, source, amount, (x$0, x$1, x$2) -> super.hurtServer(x$0, x$1, x$2));
    }

    public void destroy(ServerLevel serverLevel, DamageSource source) {
        this.kill(serverLevel);
        this.getStorageHolder().onDestroy();
    }

    @Override
    public ItemStack getDropStack(ItemStack storageItem) {
        ItemStack drop = new ItemStack((ItemLike)ModItems.STORAGE_MINECART.get());
        drop.set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)storageItem));
        return drop;
    }

    public ItemStack getPickResult() {
        ItemStack result = new ItemStack((ItemLike)ModItems.STORAGE_MINECART.get());
        ItemStack storageItemCopy = this.getStorageItem().copy();
        storageItemCopy.remove(ModCoreDataComponents.STORAGE_UUID);
        result.set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)storageItemCopy));
        return result;
    }

    protected void addAdditionalSaveData(ValueOutput out) {
        super.addAdditionalSaveData(out);
        out.putChild("storageHolder", this.entityStorageHolder);
    }

    protected void readAdditionalSaveData(ValueInput in) {
        super.readAdditionalSaveData(in);
        in.child("storageHolder").ifPresent(this.entityStorageHolder::deserialize);
    }

    public void tick() {
        super.tick();
        this.entityStorageHolder.tick((Entity)this);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == DATA_STORAGE_ITEM && this.level().isClientSide()) {
            this.entityStorageHolder.onStorageItemSynced();
        }
    }

    public void setCustomName(@Nullable Component customName) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(customName));
    }

    protected Component getTypeName() {
        return Component.translatable((String)StorageInMotionTranslationHelper.INSTANCE.translEntity("storage_minecart"), (Object[])new Object[]{this.getStorageItem().getHoverName()});
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.getStorageHolder().openContainerMenu((Player)serverPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return this.getStorageHolder().createMenu(id, playerInventory.player);
    }

    public void remove(Entity.RemovalReason pReason) {
        this.setRemoved(pReason);
    }

    public int getContainerSize() {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().size();
    }

    public NonNullList<ItemStack> getItemStacks() {
        return NonNullList.create();
    }

    public void addChestVehicleSaveData(ValueOutput out) {
        this.getLootTable().ifPresent(lootTable -> {
            out.putString("LootTable", lootTable.location().toString());
            if (this.getContainerLootTableSeed() != 0L) {
                out.putLong("LootTableSeed", this.getContainerLootTableSeed());
            }
        });
    }

    public void readChestVehicleSaveData(ValueInput in) {
        this.clearItemStacks();
        in.getString("LootTable").ifPresent(lootTable -> this.setContainerLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)lootTable))));
        in.getLong("LootTableSeed").ifPresent(arg_0 -> ((StorageMinecart)this).setContainerLootTableSeed(arg_0));
    }

    public void chestVehicleDestroyed(DamageSource damageSource, ServerLevel level, Entity p_entity) {
    }

    public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        InventoryHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryHandler();
        for (int slot = 0; slot < inventoryHandler.size(); ++slot) {
            inventoryHandler.setStackInSlot(slot, ItemStack.EMPTY);
        }
    }

    public ItemStack removeChestVehicleItemNoUpdate(int slot) {
        ITrackedContentsItemResourceHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput();
        ItemResource resource = (ItemResource)inventoryHandler.getResource(slot);
        return resource.toStack(InventoryHelper.extract((ResourceHandler)inventoryHandler, (int)slot, (ItemResource)resource, (int)inventoryHandler.getAmountAsInt(slot)));
    }

    public ItemStack getChestVehicleItem(int slot) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().getStackInSlot(slot);
    }

    public ItemStack removeChestVehicleItem(int slot, int amount) {
        ITrackedContentsItemResourceHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput();
        ItemResource resource = (ItemResource)inventoryHandler.getResource(slot);
        return resource.toStack(InventoryHelper.extract((ResourceHandler)inventoryHandler, (int)slot, (ItemResource)resource, (int)amount));
    }

    public void setChestVehicleItem(int slot, ItemStack stack) {
        this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().setStackInSlot(slot, stack);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().isValid(slot, (Resource)ItemResource.of((ItemStack)stack));
    }

    public SlotAccess getChestVehicleSlot(int index) {
        return SlotAccess.NULL;
    }
}

