/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItemClient;

public abstract class MovingStorageItem
extends ItemBase
implements IStashStorageItem {
    public MovingStorageItem(Item.Properties properties) {
        super(properties);
    }

    public static void setStorageItem(ItemStack movingStorageItem, ItemStack storageItem) {
        movingStorageItem.set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)storageItem));
    }

    public static Optional<Item> getStorageItemType(ItemStack stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents == null ? Optional.empty() : Optional.of(storageItemContents.getItem());
    }

    public static Optional<WoodType> getStorageItemWoodType(ItemStack stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents == null ? Optional.empty() : WoodStorageBlockItem.getWoodType((DataComponentHolder)storageItemContents);
    }

    public static Optional<Integer> getStorageItemMainColor(ItemStack stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents == null ? Optional.empty() : StorageBlockItem.getMainColorFromComponentHolder((DataComponentGetter)storageItemContents);
    }

    public static Optional<Integer> getStorageItemAccentColor(ItemStack stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents == null ? Optional.empty() : StorageBlockItem.getAccentColorFromComponentHolder((DataComponentGetter)storageItemContents);
    }

    public static boolean isStorageItemFlatTopBarrel(ItemStack stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents != null && BarrelBlockItem.isFlatTop((DataComponentHolder)storageItemContents);
    }

    public static ItemStack getStorageItem(DataComponentHolder stack) {
        return ((SimpleItemContent)stack.getOrDefault(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.EMPTY)).copy();
    }

    public abstract ItemStack getUncraftRemainingItem(ItemStack var1);

    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Config.COMMON.enabledItems.isItemEnabled((Item)this)) {
            List<ItemStack> movingStorages = this.getBaseMovingStorageItems();
            movingStorages.forEach(movingStorage -> {
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.copy(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.BARREL_ITEM.get()), (WoodType)WoodType.SPRUCE)));
                ItemStack limitedIStack = new ItemStack((ItemLike)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get());
                Item patt0$temp = limitedIStack.getItem();
                if (patt0$temp instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)patt0$temp;
                    tintableBlockItem.setMainColor(limitedIStack, DyeColor.YELLOW.getTextureDiffuseColor());
                    tintableBlockItem.setAccentColor(limitedIStack, DyeColor.LIME.getTextureDiffuseColor());
                }
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.copy(), limitedIStack));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.copy(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (WoodType)WoodType.BIRCH)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.copy(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.LIMITED_IRON_BARREL_3.get()), (WoodType)WoodType.ACACIA)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.copy(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.LIMITED_DIAMOND_BARREL_4.get()), (WoodType)WoodType.CRIMSON)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.copy(), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.NETHERITE_CHEST_ITEM.get()), (WoodType)WoodType.BAMBOO)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.copy(), new ItemStack((ItemLike)ModBlocks.IRON_SHULKER_BOX_ITEM.get())));
            });
        }
    }

    public List<ItemStack> getBaseMovingStorageItems() {
        return List.of(new ItemStack((ItemLike)this));
    }

    public static ItemStack createWithStorage(ItemStack movingStorage, ItemStack storageStack) {
        MovingStorageItem.setStorageItem(movingStorage, storageStack);
        return movingStorage;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        HolderLookup.Provider registries;
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        if (tooltipFlag.isAdvanced() && (registries = context.registries()) != null && MovingStorageWrapper.hasContentsUuid((ItemStack)stack)) {
            MovingStorageItem.getMovingStorageWrapper(stack).getContentsUuid().ifPresent(uuid -> tooltipAdder.accept((Component)Component.literal((String)("UUID: " + String.valueOf(uuid))).withStyle(ChatFormatting.DARK_GRAY)));
        }
        if (!Minecraft.getInstance().hasShiftDown() && MovingStorageWrapper.hasContentsUuid((ItemStack)stack)) {
            tooltipAdder.accept((Component)Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
        }
    }

    public Component getName(ItemStack stack) {
        SimpleItemContent storageItemContent = (SimpleItemContent)stack.get(ModDataComponents.STORAGE_ITEM);
        return storageItemContent != null ? Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{storageItemContent.copy().getHoverName()}) : super.getName(stack);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (FMLEnvironment.getDist().isClient()) {
            return Optional.ofNullable(MovingStorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    public Optional<TooltipComponent> getInventoryTooltip(ItemStack stack) {
        return Optional.of(new MovingStorageContentsTooltip(stack));
    }

    public IStashStorageItem.StashResult getItemStashable(HolderLookup.Provider registries, ItemStack storageStack, ItemStack stack) {
        if (MovingStorageItem.getStorageItemType(storageStack).map(item -> item instanceof ShulkerBoxItem).orElse(false).booleanValue()) {
            MovingStorageWrapper wrapper = MovingStorageItem.getMovingStorageWrapper(storageStack);
            try (Transaction tx = Transaction.openRoot();){
                if (wrapper.getInventoryForUpgradeProcessing().insert((Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)tx) == 0) {
                    IStashStorageItem.StashResult stashResult = IStashStorageItem.StashResult.NO_SPACE;
                    return stashResult;
                }
            }
            if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.getItem()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
                return IStashStorageItem.StashResult.MATCH_AND_SPACE;
            }
            return IStashStorageItem.StashResult.SPACE;
        }
        return IStashStorageItem.StashResult.NO_SPACE;
    }

    public static MovingStorageWrapper getMovingStorageWrapper(ItemStack movingStorageStack) {
        ItemStack storageItem = MovingStorageItem.getStorageItem((DataComponentHolder)movingStorageStack);
        MovingStorageWrapper wrapper = MovingStorageWrapper.fromStack((ItemStack)storageItem, () -> {}, () -> movingStorageStack.set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)storageItem)), MovingStorageData::get, () -> (Boolean)movingStorageStack.getOrDefault(net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents.LOCKED, (Object)false), locked -> movingStorageStack.set(net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents.LOCKED, locked), upgrade -> true);
        return wrapper;
    }

    public int stash(ItemStack movingStorageStack, ItemResource resource, int amount, TransactionContext tx) {
        MovingStorageWrapper wrapper = MovingStorageItem.getMovingStorageWrapper(movingStorageStack);
        if (wrapper.getContentsUuid().isEmpty()) {
            wrapper.setContentsUuid(UUID.randomUUID());
        }
        return wrapper.getInventoryForUpgradeProcessing().insert((Resource)resource, amount, tx);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (this.hasCreativeScreenContainerOpen(player) || stack.getCount() > 1 || !slot.mayPickup(player) || slot.getItem().isEmpty() || action != ClickAction.SECONDARY || !this.isShulkerBoxMovingStorage(stack)) {
            return super.overrideStackedOnOther(stack, slot, action, player);
        }
        ItemStack stackToStash = slot.getItem();
        try (Transaction tx = Transaction.openRoot();){
            int stashed = this.stash(stack, ItemResource.of((ItemStack)stackToStash), stackToStash.getCount(), (TransactionContext)tx);
            if (stashed > 0) {
                tx.commit();
                slot.safeTake(stashed, stashed, player);
                boolean bl = true;
                return bl;
            }
        }
        return super.overrideStackedOnOther(stack, slot, action, player);
    }

    private boolean isShulkerBoxMovingStorage(ItemStack movingStorageStack) {
        return MovingStorageItem.getStorageItemType(movingStorageStack).map(item -> item instanceof ShulkerBoxItem).orElse(false);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess carriedAccess) {
        if (this.hasCreativeScreenContainerOpen(player) || stack.getCount() > 1 || !slot.mayPlace(stack) || action != ClickAction.SECONDARY || !this.isShulkerBoxMovingStorage(stack)) {
            return super.overrideOtherStackedOnMe(stack, otherStack, slot, action, player, carriedAccess);
        }
        try (Transaction tx = Transaction.openRoot();){
            int stashed = this.stash(stack, ItemResource.of((ItemStack)otherStack), otherStack.getCount(), (TransactionContext)tx);
            if (stashed > 0) {
                tx.commit();
                carriedAccess.set(otherStack.copyWithCount(otherStack.getCount() - stashed));
                slot.set(stack);
                boolean bl = true;
                return bl;
            }
        }
        return super.overrideOtherStackedOnMe(stack, otherStack, slot, action, player, carriedAccess);
    }

    private boolean hasCreativeScreenContainerOpen(Player player) {
        return player.level().isClientSide() && player.containerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu;
    }

    static {
        DecorationTableBlockEntity.registerItemDecorator(item -> item instanceof MovingStorageItem, (DecorationTableBlockEntity.IItemDecorator)new DecorationTableBlockEntity.IItemDecorator(){

            public boolean supportsMaterials(ItemResource input) {
                ItemStack storageItem = MovingStorageItem.getStorageItem((DataComponentHolder)input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsMaterials(ItemResource.of((ItemStack)storageItem));
            }

            public boolean supportsTints(ItemResource input) {
                ItemStack storageItem = MovingStorageItem.getStorageItem((DataComponentHolder)input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsTints(ItemResource.of((ItemStack)storageItem));
            }

            public boolean supportsTopInnerTrim(ItemResource input) {
                ItemStack storageItem = MovingStorageItem.getStorageItem((DataComponentHolder)input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsTopInnerTrim(ItemResource.of((ItemStack)storageItem));
            }

            public ItemStack decorateWithMaterials(ItemStack input, Map<BarrelMaterial, ResourceLocation> materialsToApply) {
                ItemStack storageItem = MovingStorageItem.getStorageItem((DataComponentHolder)input);
                ItemStack storageResult = DecorationTableBlockEntity.STORAGE_DECORATOR.decorateWithMaterials(storageItem, materialsToApply);
                if (storageResult.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                ItemStack result = input.copy();
                MovingStorageItem.setStorageItem(result, storageResult);
                return result;
            }

            public DecorationTableBlockEntity.TintDecorationResult decorateWithTints(ItemStack input, int mainColorToSet, int accentColorToSet) {
                ItemStack storageItem = MovingStorageItem.getStorageItem((DataComponentHolder)input);
                DecorationTableBlockEntity.TintDecorationResult tintResult = DecorationTableBlockEntity.STORAGE_DECORATOR.decorateWithTints(storageItem, mainColorToSet, accentColorToSet);
                if (tintResult.result().isEmpty()) {
                    return DecorationTableBlockEntity.TintDecorationResult.EMPTY;
                }
                ItemStack result = input.copy();
                MovingStorageItem.setStorageItem(result, tintResult.result());
                return new DecorationTableBlockEntity.TintDecorationResult(result, tintResult.requiredDyeParts());
            }
        });
    }

    public record MovingStorageContentsTooltip(ItemStack movingStorage) implements TooltipComponent
    {
        public ItemStack getMovingStorage() {
            return this.movingStorage;
        }
    }
}

