/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBlockStateModelBase;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.StaticBlockEntityTintGetter;
import org.joml.Quaternionfc;

public class StorageBlockRenderer {
    private static final Map<Class<? extends AbstractChestedHorse>, Function<StorageBlockEntity, Vec3>> OFFSET_MAP = new LinkedHashMap<Class<? extends AbstractChestedHorse>, Function<StorageBlockEntity, Vec3>>();
    public static final Vec3 DONKEY_CHEST_OFFSET = new Vec3(0.0, -0.26, -0.1);
    public static final Vec3 DONKEY_OTHER_OFFSET = new Vec3(0.0, -0.325, -0.07);
    public static final Vec3 MULE_CHEST_OFFSET = new Vec3(0.0, -0.18, -0.13);
    public static final Vec3 MULE_OTHER_OFFSET = new Vec3(0.0, -0.24, -0.1);
    public static final Vec3 LLAMA_OTHER_OFFSET = new Vec3(0.0, -0.02, 0.0);
    private static final Function<StorageBlockEntity, Vec3> DEFAULT_OFFSET;

    public static void renderStorageBlock(float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, StorageBlockEntity renderBlockEntity) {
        BlockEntityRenderer renderer;
        BlockState state = renderBlockEntity.getBlockState();
        Minecraft minecraft = Minecraft.getInstance();
        if (renderBlockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)renderBlockEntity;
            BlockRenderDispatcher blockRenderer = minecraft.getBlockRenderer();
            BlockStateModel blockStateModel = blockRenderer.getBlockModel(barrel.getBlockState());
            if (blockStateModel instanceof BarrelBlockStateModelBase) {
                BarrelBlockStateModelBase barrelModel = (BarrelBlockStateModelBase)blockStateModel;
                barrelModel.setModelPropertiesFromBlockEntity(barrel);
            }
            StaticBlockEntityTintGetter wrappedLevel = new StaticBlockEntityTintGetter((BlockAndTintGetter)minecraft.level, (BlockEntity)renderBlockEntity, packedLight);
            List parts = blockStateModel.collectParts((BlockAndTintGetter)wrappedLevel, BlockPos.ZERO, state, RandomSource.create((long)42L));
            blockRenderer.getModelRenderer().tesselateWithoutAO((BlockAndTintGetter)wrappedLevel, parts, state, BlockPos.ZERO, poseStack, renderType -> buffer.getBuffer(RenderTypeHelper.getEntityRenderType((ChunkSectionLayer)renderType)), false, OverlayTexture.NO_OVERLAY);
        }
        if ((renderer = minecraft.getBlockEntityRenderDispatcher().getRenderer((BlockEntity)renderBlockEntity)) != null) {
            renderer.render((BlockEntity)renderBlockEntity, partialTicks, poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, Vec3.ZERO);
        }
    }

    public static void renderChestedHorseStorage(Class<? extends AbstractChestedHorse> chestedHorseClass, EntityRenderState entityRenderState, PoseStack poseStack, MultiBufferSource buffer, int packedLight, @Nullable StorageBlockEntity renderBlockEntity) {
        if (renderBlockEntity == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        Function<StorageBlockEntity, Vec3> offsetFunction = OFFSET_MAP.getOrDefault(chestedHorseClass, DEFAULT_OFFSET);
        if (offsetFunction != null) {
            poseStack.translate(offsetFunction.apply((StorageBlockEntity)renderBlockEntity).x, offsetFunction.apply((StorageBlockEntity)renderBlockEntity).y, offsetFunction.apply((StorageBlockEntity)renderBlockEntity).z);
        }
        StorageBlockRenderer.renderStorageOnSide(chestedHorseClass, entityRenderState, poseStack, 90, 1.0f, renderBlockEntity, packedLight, buffer, entityRenderState.partialTick);
        StorageBlockRenderer.renderStorageOnSide(chestedHorseClass, entityRenderState, poseStack, 270, -1.0f, renderBlockEntity, packedLight, buffer, entityRenderState.partialTick);
        poseStack.popPose();
    }

    private static void renderStorageOnSide(Class<? extends AbstractChestedHorse> chestedHorseClass, EntityRenderState entityRenderState, PoseStack poseStack, int storageRotation, float xOffsetMultiplier, StorageBlockEntity renderBlockEntity, int packedLight, MultiBufferSource buffer, float partialTick) {
        float halfWidth = entityRenderState.boundingBoxWidth / 2.0f;
        poseStack.pushPose();
        float scale = Llama.class.isAssignableFrom(chestedHorseClass) ? 0.57f : 0.5f;
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees((float)storageRotation));
        float xOffset = halfWidth * -0.49f * xOffsetMultiplier;
        float sideOffset = Llama.class.isAssignableFrom(chestedHorseClass) ? (renderBlockEntity instanceof ChestBlockEntity ? 1.0f : 0.85f) : (renderBlockEntity instanceof ChestBlockEntity ? 0.6f : 0.5f);
        float zOffset = -halfWidth * sideOffset;
        double yOffset = -entityRenderState.boundingBoxHeight * 0.379f;
        poseStack.translate((double)xOffset, yOffset, (double)zOffset);
        if (!(renderBlockEntity instanceof ChestBlockEntity)) {
            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        StorageBlockRenderer.renderStorageBlock(partialTick, poseStack, buffer, packedLight, renderBlockEntity);
        poseStack.popPose();
    }

    static {
        OFFSET_MAP.put(Donkey.class, renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? DONKEY_CHEST_OFFSET : DONKEY_OTHER_OFFSET);
        OFFSET_MAP.put(Mule.class, renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? MULE_CHEST_OFFSET : MULE_OTHER_OFFSET);
        OFFSET_MAP.put(Llama.class, renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? Vec3.ZERO : LLAMA_OTHER_OFFSET);
        OFFSET_MAP.put(AbstractChestedHorse.class, renderBlockEntity -> MULE_OTHER_OFFSET);
        DEFAULT_OFFSET = renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? new Vec3(0.0, -1.343, -0.515) : new Vec3(0.0, -1.4, -0.48);
    }
}

