/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.common.IHighlightRequestPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageSyncItemHighlightsPayload;

public class MovingStorageHighlightRequestPayloadHandler
implements IHighlightRequestPayloadHandler<List<Integer>> {
    public static MovingStorageHighlightRequestPayloadHandler INSTANCE = new MovingStorageHighlightRequestPayloadHandler();
    public static final ResourceLocation ID = SophisticatedStorageInMotion.getRL("moving_storage_highlight_request");

    private MovingStorageHighlightRequestPayloadHandler() {
    }

    public ResourceLocation id() {
        return ID;
    }

    public StreamCodec<ByteBuf, List<Integer>> requestCodec() {
        return ByteBufCodecs.INT.apply(ByteBufCodecs.list());
    }

    public IHighlightRequestPayloadHandler.HighlightResult compute(ServerPlayer player, ItemStackKey stackKey, List<Integer> clientData) {
        ArrayList<Integer> entitiesWithStack = new ArrayList<Integer>();
        ArrayList<Integer> entitiesWithItem = new ArrayList<Integer>();
        clientData.forEach(entityId -> {
            Entity entity = player.level().getEntity(entityId.intValue());
            if (entity instanceof IMovingStorageEntity) {
                IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)entity;
                ISlotTracker slotTracker = movingStorageEntity.getStorageHolder().getStorageWrapper().getInventoryHandler().getSlotTracker();
                if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey)) {
                    entitiesWithStack.add((Integer)entityId);
                } else if (slotTracker.getItems().contains(stackKey.getStack().getItem())) {
                    entitiesWithItem.add((Integer)entityId);
                }
            }
        });
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MovingStorageSyncItemHighlightsPayload(entitiesWithStack, entitiesWithItem), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return new IHighlightRequestPayloadHandler.HighlightResult(entitiesWithStack.size(), entitiesWithItem.size());
    }
}

