/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.StorageBoatItemRenderer;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageBoat;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class StorageBoatItem
extends MovingStorageItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private static final String RAFT_DESCRIPTION_ID = "item.sophisticatedstorageinmotion.storage_raft";
    private static final String BOAT_TYPE_TAG = "boatType";
    public static final Map<Boat.Type, Supplier<Item>> SUPPORTED_BOAT_TYPES = Map.of(Boat.Type.ACACIA, () -> Items.f_42745_, Boat.Type.BAMBOO, () -> Items.f_244624_, Boat.Type.BIRCH, () -> Items.f_42743_, Boat.Type.CHERRY, () -> Items.f_271386_, Boat.Type.DARK_OAK, () -> Items.f_42746_, Boat.Type.JUNGLE, () -> Items.f_42744_, Boat.Type.MANGROVE, () -> Items.f_220204_, Boat.Type.OAK, () -> Items.f_42453_, Boat.Type.SPRUCE, () -> Items.f_42742_);
    public static final DefaultDispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double yOffset;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = source.m_7727_();
            double halfWidth = 0.5625 + (double)EntityType.f_20552_.m_20678_() / 2.0;
            double x = source.m_7096_() + (double)direction.m_122429_() * halfWidth;
            double y = source.m_7098_() + (double)direction.m_122430_() * 1.125;
            double z = source.m_7094_() + (double)direction.m_122431_() * halfWidth;
            BlockPos blockpos = source.m_7961_().m_121945_(direction);
            Boat boat = StorageBoatItem.createBoat((Level)level, null, stack, x, y, z);
            boat.m_146922_(direction.m_122435_());
            if (boat.canBoatInFluid(level.m_6425_(blockpos))) {
                yOffset = 1.0;
            } else {
                if (!level.m_8055_(blockpos).m_60795_() || !boat.canBoatInFluid(level.m_6425_(blockpos.m_7495_()))) {
                    return this.defaultDispenseItemBehavior.m_6115_(source, stack);
                }
                yOffset = 0.0;
            }
            boat.m_6034_(x, y + yOffset, z);
            level.m_7967_((Entity)boat);
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource pSource) {
            pSource.m_7727_().m_46796_(1000, pSource.m_7961_(), 0);
        }
    };

    public StorageBoatItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public ItemStack getUncraftRemainingItem(ItemStack input) {
        return new ItemStack((ItemLike)SUPPORTED_BOAT_TYPES.getOrDefault(StorageBoatItem.getBoatType(input), () -> Items.f_42453_).get());
    }

    @Override
    public List<ItemStack> getBaseMovingStorageItems() {
        return SUPPORTED_BOAT_TYPES.keySet().stream().map(type -> StorageBoatItem.setBoatType(new ItemStack((ItemLike)this), type)).toList();
    }

    public static Boat.Type getBoatType(ItemStack boatStack) {
        return NBTHelper.getEnumConstant((ItemStack)boatStack, (String)BOAT_TYPE_TAG, Boat.Type::m_38432_).orElse(Boat.Type.OAK);
    }

    public static ItemStack setBoatType(ItemStack boatStack, Boat.Type type) {
        NBTHelper.setEnumConstant((ItemStack)boatStack, (String)BOAT_TYPE_TAG, (Enum)type);
        return boatStack;
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        return NBTHelper.getCompound((ItemStack)stack, (String)"storageItem").map(ItemStack::m_41712_).map(storageItem -> {
            Boat.Type boatType = StorageBoatItem.getBoatType(stack);
            String descriptionId = boatType == Boat.Type.BAMBOO ? RAFT_DESCRIPTION_ID : this.m_5524_();
            return Component.m_237110_((String)descriptionId, (Object[])new Object[]{this.getWoodName(boatType), storageItem.m_41786_()});
        }).orElse(super.m_7626_(stack));
    }

    private Component getWoodName(Boat.Type type) {
        return Component.m_237115_((String)("wood_name.sophisticatedstorage." + type.name().toLowerCase(Locale.ROOT)));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult hitresult = StorageBoatItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 playerViewVector = player.m_20252_(1.0f);
        List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(playerViewVector.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 eyePosition = player.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(eyePosition)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 location = hitresult.m_82450_();
            Boat boat = StorageBoatItem.createBoat(level, player, itemstack, location.f_82479_, location.f_82480_, location.f_82481_);
            if (!level.m_45756_((Entity)boat, boat.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)boat);
                level.m_220400_((Entity)player, GameEvent.f_157810_, hitresult.m_82450_());
                itemstack.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private static Boat createBoat(Level level, @Nullable Player player, ItemStack stack, double x, double y, double z) {
        StorageBoat boat = new StorageBoat(level, x, y, z);
        EntityStorageHolder<?> storageHolder = boat.getStorageHolder();
        storageHolder.setStorageItemFromMovingStorage(stack, true);
        storageHolder.onPlace();
        boat.m_28464_(StorageBoatItem.getBoatType(stack));
        if (player != null) {
            boat.m_146922_(player.m_146908_());
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType.m_263562_((ServerLevel)serverLevel, (ItemStack)stack, (Player)player).accept(boat);
        }
        return boat;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new StorageBoatItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }
}

