/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.CustomShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageFromStorageRecipe
extends CustomShapelessRecipe
implements IWrapperRecipe<ShapelessRecipe> {
    private final ShapelessRecipe compose;

    public MovingStorageFromStorageRecipe(ShapelessRecipe compose) {
        super(compose.group(), compose.category(), compose.result, compose.ingredients);
        this.compose = compose;
    }

    public boolean matches(CraftingInput input, Level level) {
        return super.matches(input, level) && this.getStorage(input).map(c -> !WoodStorageBlockItem.isPacked((ItemStack)c)).orElse(false) != false;
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getStorage(CraftingInput inv) {
        for (int slot = 0; slot < inv.size(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = inv.getItem(slot);
            Item item = slotStack.getItem();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof StorageBlockBase)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack movingStorageItem = super.assemble(input, registries);
        this.getStorage(input).ifPresent(storage -> MovingStorageItem.setStorageItem(movingStorageItem, storage));
        return movingStorageItem;
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public RecipeSerializer<MovingStorageFromStorageRecipe> getSerializer() {
        return ModItems.MOVING_STORAGE_FROM_STORAGE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapelessRecipe, MovingStorageFromStorageRecipe> {
        public Serializer() {
            super(MovingStorageFromStorageRecipe::new, RecipeSerializer.SHAPELESS_RECIPE);
        }
    }
}

