/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common;

import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.HighlightRequestPayloadHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.common.IHighlightRequestPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.ITintable;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderToolHandler;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.PackingTapeItem;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.MovingStorageHighlightRequestPayloadHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.TierUpgradeHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class CommonEventHandler {
    private CommonEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(CommonEventHandler::onMovingStorageUncrafted);
        eventBus.addListener(CommonEventHandler::onMovingStorageCraftedFromShulkerBox);
        eventBus.addListener(TierUpgradeHandler::onTierUpgradeInteract);
        eventBus.addListener(CommonEventHandler::onStorageToolInteract);
        eventBus.addListener(CommonEventHandler::onPacked);
        eventBus.addListener(CommonEventHandler::onPaintbrushInteract);
        eventBus.addListener(CommonEventHandler::onStorageUpgradeInteract);
        CommonEventHandler.registerHighlightRequestPayloadHandler();
    }

    private static void registerHighlightRequestPayloadHandler() {
        HighlightRequestPayloadHandlerRegistry.register((IHighlightRequestPayloadHandler)MovingStorageHighlightRequestPayloadHandler.INSTANCE);
    }

    private static void onStorageUpgradeInteract(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorage;
        ItemStack itemInHand;
        Player player;
        block5: {
            block4: {
                player = event.getEntity();
                itemInHand = player.m_21120_(event.getHand());
                Entity entity = event.getTarget();
                if (!(entity instanceof IMovingStorageEntity)) break block4;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.m_41720_() instanceof UpgradeItemBase) break block5;
            }
            return;
        }
        if (StorageBlockBase.tryAddSingleUpgrade((Player)player, (InteractionHand)event.getHand(), (ItemStack)itemInHand, (IStorageWrapper)movingStorage.getStorageHolder().getStorageWrapper())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    private static void onPaintbrushInteract(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorage;
        ItemStack itemInHand;
        Player player;
        block6: {
            block5: {
                player = event.getEntity();
                itemInHand = player.m_21120_(event.getHand());
                Entity entity = event.getTarget();
                if (!(entity instanceof IMovingStorageEntity)) break block5;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.m_41720_() == ModItems.PAINTBRUSH.get()) break block6;
            }
            return;
        }
        Item item = movingStorage.getStorageItem().m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.m_40614_().m_49966_();
        SoundEvent placeSound = state.m_60827_().m_56777_();
        if (PaintbrushItem.paint((Player)player, (ItemStack)itemInHand, movingStorage.getStorageHolder(), (ITintable)movingStorage.getStorageHolder().getStorageWrapper(), (Vec3)event.getTarget().m_20182_(), (Direction)Direction.UP, (SoundEvent)placeSound)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    private static void onPacked(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorage;
        ItemStack itemInHand;
        Player player;
        block7: {
            block6: {
                player = event.getEntity();
                itemInHand = player.m_21120_(event.getHand());
                Entity entity = event.getTarget();
                if (!(entity instanceof IMovingStorageEntity)) break block6;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.m_41720_() instanceof PackingTapeItem && !((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) break block7;
            }
            return;
        }
        if (movingStorage.getStorageHolder().pack()) {
            if (!player.m_7500_()) {
                itemInHand.m_41721_(itemInHand.m_41773_() + 1);
                if (itemInHand.m_41773_() >= itemInHand.m_41776_()) {
                    player.m_21008_(event.getHand(), ItemStack.f_41583_);
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    private static void onMovingStorageUncrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (event.getEntity().m_9236_().m_5776_() || !(result.m_41720_() instanceof StorageBlockItem) || !CommonEventHandler.isUncraftedFromSingleMovingStorage(event.getInventory())) {
            return;
        }
        NBTHelper.getUniqueId((ItemStack)result, (String)"uuid").ifPresent(storageId -> MovingStorageData.moveToItemStorage(result, storageId));
    }

    private static boolean isUncraftedFromSingleMovingStorage(Container inventory) {
        boolean hasMovingStorage = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!hasMovingStorage && stack.m_41720_() instanceof MovingStorageItem) {
                hasMovingStorage = true;
                continue;
            }
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private static void onMovingStorageCraftedFromShulkerBox(PlayerEvent.ItemCraftedEvent event) {
        Level level = event.getEntity().m_9236_();
        ItemStack result = event.getCrafting();
        if (level.m_5776_()) {
            return;
        }
        if (!CommonEventHandler.isCraftedFromShulkerBox(event.getInventory())) {
            return;
        }
        ItemStack storageItem = MovingStorageItem.getStorageItem(result);
        if (storageItem.m_41720_() instanceof ShulkerBoxItem) {
            UUID uuid = NBTHelper.getUniqueId((ItemStack)storageItem, (String)"uuid").orElse(null);
            if (uuid != null) {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                CompoundTag contentsNbt = itemContentsStorage.getOrCreateStorageContents(uuid).m_128469_("storageWrapper");
                CompoundTag migratedContentsNbt = new CompoundTag();
                migratedContentsNbt.m_128365_("contents", (Tag)contentsNbt.m_128469_("contents"));
                migratedContentsNbt.m_128365_("settings", (Tag)contentsNbt.m_128469_("settings"));
                MovingStorageData.get(uuid).setContents(migratedContentsNbt);
                storageItem.m_41784_().m_128365_("renderInfo", (Tag)contentsNbt.m_128469_("renderInfo"));
                MovingStorageItem.setStorageItem(storageItem, result);
                itemContentsStorage.removeStorageContents(uuid);
            }
            MovingStorageItem.setStorageItem(result, storageItem);
        }
    }

    private static boolean isCraftedFromShulkerBox(Container craftingGrid) {
        boolean foundShulker = false;
        for (int slot = 0; slot < craftingGrid.m_6643_(); ++slot) {
            if (!(craftingGrid.m_8020_(slot).m_41720_() instanceof ShulkerBoxItem)) continue;
            foundShulker = true;
        }
        return foundShulker;
    }

    public static void onStorageToolInteract(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorageEntity;
        ItemStack itemInHand;
        block5: {
            block4: {
                Player player = event.getEntity();
                itemInHand = player.m_21120_(event.getHand());
                Entity entity = event.getTarget();
                if (!(entity instanceof IMovingStorageEntity)) break block4;
                movingStorageEntity = (IMovingStorageEntity)entity;
                if (itemInHand.m_41720_() == ModItems.STORAGE_TOOL.get() && !movingStorageEntity.getStorageHolder().isPacked()) break block5;
            }
            return;
        }
        InteractionResult result = StorageHolderToolHandler.tryStorageToolInteract((ItemStack)itemInHand, movingStorageEntity.getStorageHolder());
        if (result.m_19077_()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }
}

