/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.p3pp3rf1y.sophisticatedcore.common.IHighlightRequestPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageSyncItemHighlightsMessage;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.StorageInMotionPacketHandler;

public class MovingStorageHighlightRequestPayloadHandler
implements IHighlightRequestPayloadHandler<List<Integer>> {
    public static MovingStorageHighlightRequestPayloadHandler INSTANCE = new MovingStorageHighlightRequestPayloadHandler();
    public static final ResourceLocation ID = SophisticatedStorageInMotion.getRL("moving_storage_highlight_request");

    private MovingStorageHighlightRequestPayloadHandler() {
    }

    public ResourceLocation id() {
        return ID;
    }

    public IHighlightRequestPayloadHandler.HighlightResult compute(ServerPlayer player, ItemStackKey stackKey, List<Integer> clientData) {
        ArrayList<Integer> entitiesWithStack = new ArrayList<Integer>();
        ArrayList<Integer> entitiesWithItem = new ArrayList<Integer>();
        clientData.forEach(entityId -> {
            Entity entity = player.m_9236_().m_6815_(entityId.intValue());
            if (entity instanceof IMovingStorageEntity) {
                IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)entity;
                ISlotTracker slotTracker = movingStorageEntity.getStorageHolder().getStorageWrapper().getInventoryHandler().getSlotTracker();
                if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey)) {
                    entitiesWithStack.add((Integer)entityId);
                } else if (slotTracker.getItems().contains(stackKey.getStack().m_41720_())) {
                    entitiesWithItem.add((Integer)entityId);
                }
            }
        });
        StorageInMotionPacketHandler.INSTANCE.sendToClient(player, new MovingStorageSyncItemHighlightsMessage(entitiesWithStack, entitiesWithItem));
        return new IHighlightRequestPayloadHandler.HighlightResult(entitiesWithStack.size(), entitiesWithItem.size());
    }

    public List<Integer> decode(FriendlyByteBuf packetBuffer) {
        return (List)packetBuffer.m_236838_(ArrayList::new, FriendlyByteBuf::readInt);
    }

    public void encode(FriendlyByteBuf packetBuffer, List<Integer> value) {
        packetBuffer.m_236828_(value, FriendlyByteBuf::writeInt);
    }
}

