/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageFromStorageRecipe;

public class AssembleRecipesMaker {
    private AssembleRecipesMaker() {
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<CraftingRecipe> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return AssembleRecipesMaker.getShapelessCraftingRecipes(getSubtypeInterpreter, r -> r);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, Function<CraftingRecipe, R> transformRecipe) {
        RecipeConstructor<MovingStorageFromStorageRecipe> constructRecipe = (originalRecipe, ingredients, result) -> new ShapelessRecipe(originalRecipe.m_6423_(), "", CraftingBookCategory.MISC, result, ingredients);
        return AssembleRecipesMaker.getCraftingRecipes(constructRecipe, MovingStorageFromStorageRecipe.class, getSubtypeInterpreter, transformRecipe);
    }

    private static <R, T extends CraftingRecipe, U extends PropertyBasedSubtypeInterpreter> List<R> getCraftingRecipes(RecipeConstructor<T> constructRecipe, Class<T> originalRecipeClass, Function<ItemStack, Optional<U>> getSubtypeInterpreter, Function<CraftingRecipe, R> transformRecipe) {
        return ClientRecipeHelper.transformAllRecipesOfTypeIntoMultiple((RecipeType)RecipeType.f_44107_, originalRecipeClass, recipe -> {
            ArrayList itemGroupRecipes = new ArrayList();
            int storageIngredientIndex = -1;
            NonNullList ingredients = recipe.m_7527_();
            TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                public ItemStack m_7648_(Player player, int index) {
                    return ItemStack.f_41583_;
                }

                public boolean m_6875_(Player playerIn) {
                    return false;
                }
            }, 3, 3);
            NonNullList ingredientsTemplate = NonNullList.m_182647_((int)ingredients.size());
            List<Object> storageItems = new ArrayList();
            int i = 0;
            for (Ingredient ingredient : ingredients) {
                ItemStack[] ingredientItems = ingredient.m_43908_();
                if (ingredientItems.length > 0 && ingredientItems[0].m_41720_() instanceof StorageBlockItem) {
                    storageItems = AssembleRecipesMaker.expandStorageItems(ingredient.m_43908_());
                    storageIngredientIndex = i;
                    ingredientsTemplate.add(i, (Object)Ingredient.f_43901_);
                } else {
                    ingredientsTemplate.add(i, (Object)ingredient);
                    if (!ingredient.m_43947_()) {
                        craftinginventory.m_6836_(i, ingredientItems[0]);
                    }
                }
                ++i;
            }
            for (ItemStack storageItem : storageItems) {
                NonNullList ingredientsCopy = NonNullList.m_182647_((int)ingredientsTemplate.size());
                ingredientsCopy.addAll((Collection)ingredientsTemplate);
                ingredientsCopy.set(storageIngredientIndex, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{storageItem}));
                craftinginventory.m_6836_(storageIngredientIndex, storageItem.m_41777_());
                ItemStack result = ClientRecipeHelper.assemble((Recipe)recipe, (Container)craftinginventory);
                ResourceLocation id = new ResourceLocation("sophisticatedstorageinmotion", "assemble_moving_storage_" + ((Optional)getSubtypeInterpreter.apply(result)).map(intepreter -> intepreter.getRegistrySanitizedItemString(result)).orElse(""));
                itemGroupRecipes.add(transformRecipe.apply(constructRecipe.construct(recipe, (NonNullList<Ingredient>)ingredientsCopy, result)));
            }
            return itemGroupRecipes;
        });
    }

    private static List<ItemStack> expandStorageItems(ItemStack[] items) {
        ArrayList<ItemStack> storageItems = new ArrayList<ItemStack>();
        HashSet<Item> alreadyExpanded = new HashSet<Item>();
        for (ItemStack item : items) {
            Item item2;
            if (!alreadyExpanded.add(item.m_41720_()) || !((item2 = item.m_41720_()) instanceof StorageBlockItem)) continue;
            StorageBlockItem storageBlockItem = (StorageBlockItem)item2;
            storageBlockItem.addCreativeTabItems(storageItems::add);
        }
        return storageItems;
    }

    private static interface RecipeConstructor<T extends Recipe<?>> {
        public CraftingRecipe construct(T var1, NonNullList<Ingredient> var2, ItemStack var3);
    }
}

