/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class UncraftMovingStorageRecipe
extends CustomRecipe {
    public UncraftMovingStorageRecipe(ResourceLocation registryName, CraftingBookCategory category) {
        super(registryName, category);
    }

    public boolean m_5598_() {
        return true;
    }

    private Optional<ItemStack> getMovingStorage(CraftingContainer inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (!(slotStack.m_41720_() instanceof MovingStorageItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean hasMovingStorage = false;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (!hasMovingStorage && slotStack.m_41720_() instanceof MovingStorageItem) {
                hasMovingStorage = true;
                continue;
            }
            if (slotStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer input, RegistryAccess registries) {
        return this.getMovingStorage(input).map(MovingStorageItem::getStorageItem).orElse(ItemStack.f_41583_);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer input) {
        NonNullList remainingItems = NonNullList.m_122780_((int)input.m_6643_(), (Object)ItemStack.f_41583_);
        for (int slot = 0; slot < input.m_6643_(); ++slot) {
            ItemStack slotStack = input.m_8020_(slot);
            Item item = slotStack.m_41720_();
            if (!(item instanceof MovingStorageItem)) continue;
            MovingStorageItem movingStorageItem = (MovingStorageItem)item;
            remainingItems.set(slot, (Object)movingStorageItem.getUncraftRemainingItem(slotStack));
        }
        return remainingItems;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.UNCRAFT_MOVING_STORAGE_SERIALIZER.get();
    }
}

