/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.StorageMinecartItemRenderer;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageMinecart;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class StorageMinecartItem
extends MovingStorageItem {
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource blockSource, ItemStack stack) {
            double slopeOffset;
            RailShape railshape;
            BlockPos blockpos;
            Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel serverlevel = blockSource.m_7727_();
            BlockState blockstate = serverlevel.m_8055_(blockpos = blockSource.m_7961_().m_121945_(direction));
            Block block = blockstate.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baseRailBlock = (BaseRailBlock)block;
                v0 = baseRailBlock.getRailDirection(blockstate, (BlockGetter)serverlevel, blockpos, null);
            } else {
                v0 = railshape = RailShape.NORTH_SOUTH;
            }
            if (blockstate.m_204336_(BlockTags.f_13034_)) {
                slopeOffset = railshape.m_61745_() ? 0.6 : 0.1;
            } else {
                RailShape railShape;
                if (!blockstate.m_60795_() || !serverlevel.m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    return this.defaultDispenseItemBehavior.m_6115_(blockSource, stack);
                }
                BlockState stateBelow = serverlevel.m_8055_(blockpos.m_7495_());
                Block block2 = stateBelow.m_60734_();
                if (block2 instanceof BaseRailBlock) {
                    BaseRailBlock baseRailBlock = (BaseRailBlock)block2;
                    railShape = baseRailBlock.getRailDirection(stateBelow, (BlockGetter)serverlevel, blockpos.m_7495_(), null);
                } else {
                    railShape = RailShape.NORTH_SOUTH;
                }
                RailShape railShapeBelow = railShape;
                slopeOffset = direction != Direction.DOWN && railShapeBelow.m_61745_() ? -0.4 : -0.9;
            }
            serverlevel.m_7967_((Entity)StorageMinecartItem.createMinecart(serverlevel, blockpos, slopeOffset, stack, null));
            stack.m_41774_(1);
            return stack;
        }
    };

    public StorageMinecartItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.m_43725_();
        BlockState blockstate = level.m_8055_(blockpos = context.m_8083_());
        if (!blockstate.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        if (level instanceof ServerLevel) {
            RailShape railShape;
            ServerLevel serverlevel = (ServerLevel)level;
            Block block = blockstate.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baseRailBlock = (BaseRailBlock)block;
                railShape = baseRailBlock.getRailDirection(blockstate, (BlockGetter)level, blockpos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double ascendingOffset = 0.0;
            if (railshape.m_61745_()) {
                ascendingOffset = 0.5;
            }
            Player player = context.m_43723_();
            serverlevel.m_7967_((Entity)StorageMinecartItem.createMinecart(serverlevel, blockpos, ascendingOffset, stack, player));
            serverlevel.m_220407_(GameEvent.f_157810_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)serverlevel.m_8055_(blockpos.m_7495_())));
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static StorageMinecart createMinecart(ServerLevel serverlevel, BlockPos blockpos, double ascendingOffset, ItemStack stack, @Nullable Player player) {
        StorageMinecart minecart = new StorageMinecart((Level)serverlevel, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + ascendingOffset, (double)blockpos.m_123343_() + 0.5);
        EntityStorageHolder<?> storageHolder = minecart.getStorageHolder();
        storageHolder.setStorageItemFromMovingStorage(stack, true);
        storageHolder.onPlace();
        EntityType.m_263562_((ServerLevel)serverlevel, (ItemStack)stack, (Player)player).accept(minecart);
        return minecart;
    }

    @Override
    public ItemStack getUncraftRemainingItem(ItemStack input) {
        return new ItemStack((ItemLike)Items.f_42449_);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new StorageMinecartItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }
}

