/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingLimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.ItemComponentHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageOpennessPayload;

public class EntityStorageHolder<T extends Entity>
extends StorageHolderBase
implements ValueIOSerializable {
    private static final int AVERAGE_DROPPED_ITEM_ENTITY_STACK_SIZE = 20;
    private final T entity;
    @Nullable
    private StorageBlockEntity renderBlockEntity = null;

    public EntityStorageHolder(T entity) {
        super(!(entity instanceof AbstractChestedHorse));
        this.entity = entity;
    }

    protected Entity getEntity() {
        return this.entity;
    }

    protected boolean isOwnContainer(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof MovingStorageContainerMenu) {
            MovingStorageContainerMenu movingStorageContainerMenu = (MovingStorageContainerMenu)abstractContainerMenu;
            return movingStorageContainerMenu.getStorageEntity().map(e -> e == this.entity).orElse(false);
        }
        return false;
    }

    public void setStorageItemFromMovingStorage(ItemStack movingStorageStack, boolean setupDefaults) {
        SimpleItemContent storageItemContents = (SimpleItemContent)movingStorageStack.get(ModDataComponents.STORAGE_ITEM.get());
        if (storageItemContents == null) {
            ItemStack barrel = new ItemStack((ItemLike)ModBlocks.BARREL_ITEM.get());
            WoodStorageBlockItem.setWoodType((ItemStack)barrel, (WoodType)WoodType.SPRUCE);
            this.setStorageItem(barrel);
        } else {
            ItemStack storageItem = storageItemContents.copy();
            this.setStorageItemFrom(storageItem, setupDefaults);
        }
    }

    protected float getUpgradeRenderYOffset() {
        if (this.entity instanceof AbstractChestedHorse) {
            return 1.2f;
        }
        return super.getUpgradeRenderYOffset();
    }

    public void setStorageItemFrom(ItemStack storageItem, boolean setupDefaults) {
        this.setStorageItem(storageItem);
        if (setupDefaults && MovingStorageWrapper.isLimitedBarrel((ItemStack)storageItem)) {
            int n;
            IStorageWrapper iStorageWrapper;
            IStorageWrapper iStorageWrapper2 = iStorageWrapper = this.getStorageWrapper();
            if (iStorageWrapper instanceof MovingStorageWrapper) {
                MovingStorageWrapper movingStorageWrapper = (MovingStorageWrapper)iStorageWrapper;
                n = movingStorageWrapper.getNumberOfInventorySlots();
            } else {
                n = this.getStorageWrapper().getInventoryHandler().getSlots();
            }
            LimitedBarrelBlockEntity.setFixedSettings((IStorageWrapper)iStorageWrapper2, (int)n);
            LimitedBarrelBlock.setupDefaultSettings((IStorageWrapper)this.getStorageWrapper());
        }
    }

    private void setRenderBlockEntity(StorageBlockEntity storageBlockEntity) {
        this.renderBlockEntity = storageBlockEntity;
    }

    protected void setSyncedStorageStack(ItemStack storageStack) {
        ((IMovingStorageEntity)this.entity).setStorageItem(storageStack);
    }

    protected ItemStack getSyncedStorageStack() {
        return ((IMovingStorageEntity)this.entity).getStorageItem();
    }

    protected IStorageSavedData getStorageData() {
        return MovingStorageData.get();
    }

    public boolean isLocked(ItemStack stack) {
        return (Boolean)stack.getOrDefault(net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents.LOCKED, (Object)false);
    }

    @Nullable
    protected Level getLevel() {
        return this.entity.level();
    }

    protected Vec3 getPosition() {
        return this.entity.position();
    }

    protected CustomPacketPayload createOpennessPayload() {
        return new MovingStorageOpennessPayload(this.entity.getId(), this.isOpen());
    }

    @Nullable
    protected StorageBlockEntity retrieveRenderBlockEntity() {
        ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        if (this.renderBlockEntity == null) {
            Item item = storageItem.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (blockItem.getBlock() instanceof ChestBlock) {
                    this.renderBlockEntity = new ChestBlockEntity(BlockPos.ZERO, blockItem.getBlock().defaultBlockState());
                } else if (blockItem.getBlock() instanceof LimitedBarrelBlock) {
                    this.renderBlockEntity = new LimitedBarrelBlockEntity(BlockPos.ZERO, (BlockState)((BlockState)blockItem.getBlock().defaultBlockState().setValue((Property)LimitedBarrelBlock.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)LimitedBarrelBlock.VERTICAL_FACING, (Comparable)VerticalFacing.UP));
                } else if (blockItem.getBlock() instanceof BarrelBlock) {
                    this.renderBlockEntity = new BarrelBlockEntity(BlockPos.ZERO, (BlockState)blockItem.getBlock().defaultBlockState().setValue((Property)BarrelBlock.FACING, (Comparable)Direction.UP));
                } else if (blockItem.getBlock() instanceof ShulkerBoxBlock) {
                    this.renderBlockEntity = new ShulkerBoxBlockEntity(BlockPos.ZERO, blockItem.getBlock().defaultBlockState());
                }
            }
            if (this.renderBlockEntity == null) {
                this.renderBlockEntity = new ChestBlockEntity(BlockPos.ZERO, ((ChestBlock)ModBlocks.CHEST.get()).defaultBlockState());
            }
            this.setRenderBlockEntity(this.renderBlockEntity);
            this.renderBlockEntity.setLevel(this.entity.level());
        }
        return this.renderBlockEntity;
    }

    public void onDestroy() {
        ServerLevel serverLevel;
        Level level = this.entity.level();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) {
                this.pack();
            }
            ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
            if (!this.isShulkerBox() && !this.isPacked()) {
                this.dropAllItems();
                UUID storageId = (UUID)storageItem.get(ModCoreDataComponents.STORAGE_UUID);
                if (storageId != null) {
                    MovingStorageData.get().removeStorageContents(storageId);
                }
                storageItem = ItemComponentHelper.cleanUpStack(storageItem);
            }
            ItemStack drop = ((IMovingStorageEntity)this.entity).getDropStack(storageItem);
            if (this.entity.hasCustomName()) {
                drop.set(DataComponents.CUSTOM_NAME, (Object)this.entity.getCustomName());
            }
            this.entity.spawnAtLocation(serverLevel, drop);
        }
    }

    private void dropAllItems() {
        InventoryHelper.dropItems((ItemStackHandler)this.getStorageWrapper().getInventoryHandler(), (Level)this.entity.level(), (double)this.entity.position().x(), (double)this.entity.position().y(), (double)this.entity.position().z());
        InventoryHelper.dropItems((ItemStackHandler)this.getStorageWrapper().getUpgradeHandler(), (Level)this.entity.level(), (double)this.entity.position().x(), (double)this.entity.position().y(), (double)this.entity.position().z());
    }

    protected void setLocked(boolean locked) {
        ((IMovingStorageEntity)this.entity).getStorageItem().set(net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents.LOCKED, (Object)locked);
    }

    public boolean pack() {
        if (this.isShulkerBox() || this.isPacked()) {
            return false;
        }
        ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        WoodStorageBlockItem.setPacked((ItemStack)storageItem, (boolean)true);
        this.setStorageItem(storageItem);
        return true;
    }

    public void onPlace() {
        if (this.isPacked()) {
            ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
            WoodStorageBlockItem.setPacked((ItemStack)storageItem, (boolean)false);
            this.setStorageItem(storageItem);
        }
    }

    private boolean canBeHurtByWithFeedback(DamageSource source) {
        Entity entity;
        if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue() || this.isPacked() || !((entity = source.getEntity()) instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        if (player.isCrouching() || this.isShulkerBox()) {
            return true;
        }
        AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
        InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
            if (stack.isEmpty()) {
                return;
            }
            droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.getCount() / (double)Math.min(stack.getMaxStackSize(), 20)));
        });
        if (droppedItemEntityCount.get() <= (Integer)Config.SERVER.tooManyItemEntityDrops.get()) {
            return true;
        }
        ItemBase packingTapeItem = (ItemBase)ModItems.PACKING_TAPE.get();
        MutableComponent packingTapeItemName = packingTapeItem.getName(new ItemStack((ItemLike)packingTapeItem)).copy().withStyle(ChatFormatting.GREEN);
        if (player.getServer() != null) {
            player.getServer().sendSystemMessage((Component)StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{this.entity.getName().copy().withStyle(ChatFormatting.GREEN), Component.literal((String)String.valueOf(droppedItemEntityCount.get())).withStyle(ChatFormatting.RED), packingTapeItemName}));
        }
        return false;
    }

    public boolean hurt(ServerLevel serverLevel, DamageSource source, float amount, IHurtHandler superHurt) {
        if (this.canBeHurtByWithFeedback(source) && superHurt.apply(serverLevel, source, amount)) {
            Entity entity = source.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.getAbilities().instabuild && this.entity.isRemoved()) {
                    this.dropAllItems();
                }
            }
            return true;
        }
        return false;
    }

    public void serialize(ValueOutput out) {
        out.storeNullable("storageItem", ItemStack.CODEC, (Object)((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public void deserialize(ValueInput in) {
        in.read("storageItem", ItemStack.CODEC).ifPresent(arg_0 -> ((EntityStorageHolder)this).setStorageItem(arg_0));
    }

    protected AABB getPickupBoundingBox() {
        return this.getEntity().getBoundingBox().inflate(0.2);
    }

    protected void openMenu(Player player) {
        player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> this.createMenu(w, pl), this.entity.getName(), false), buffer -> buffer.writeInt(this.entity.getId()));
    }

    public MovingStorageContainerMenu<? extends Entity> createMenu(int id, Player pl) {
        if (MovingStorageWrapper.isLimitedBarrel((ItemStack)((IMovingStorageEntity)this.entity).getStorageItem())) {
            return new MovingLimitedBarrelContainerMenu(id, pl, this.entity.getId());
        }
        return new MovingStorageContainerMenu(id, pl, this.entity.getId());
    }

    protected void playSound(SoundEvent sound) {
        this.entity.level().playSound(null, this.entity, sound, SoundSource.BLOCKS, 0.5f, this.entity.level().random.nextFloat() * 0.1f + 0.9f);
    }

    protected void refreshRenderBlockEntity() {
        this.renderBlockEntity = null;
    }

    public static interface IHurtHandler {
        public boolean apply(ServerLevel var1, DamageSource var2, float var3);
    }
}

