/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.data;

import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.common.Tags;
import net.p3pp3rf1y.sophisticatedcore.crafting.ShapeBasedRecipeBuilder;
import net.p3pp3rf1y.sophisticatedcore.crafting.ShapelessBasedRecipeBuilder;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageFromStorageRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageIngredient;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageTierUpgradeShapedRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.UncraftMovingStorageRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.StorageBoatItem;

public class StorageInMotionRecipeProvider
extends RecipeProvider {
    public StorageInMotionRecipeProvider(DataGenerator generator, CompletableFuture<HolderLookup.Provider> registries) {
        super(generator.getPackOutput(), registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        SpecialRecipeBuilder.special(UncraftMovingStorageRecipe::new).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName("uncraft_moving_storage"));
        ShapelessBasedRecipeBuilder.shapeless((ItemLike)((ItemLike)ModItems.STORAGE_MINECART.get()), MovingStorageFromStorageRecipe::new).requires((ItemLike)Items.MINECART).requires(ModBlocks.ALL_STORAGE_TAG).unlockedBy("has_sophisticated_storage", StorageInMotionRecipeProvider.has((TagKey)ModBlocks.ALL_STORAGE_TAG)).save(recipeOutput);
        this.addStorageBoatFromStorageRecipes(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemStack)MovingStorageItem.createWithStorage(new ItemStack((ItemLike)ModItems.STORAGE_MINECART.get()), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), (WoodType)WoodType.OAK))).requires((ItemLike)Items.CHEST_MINECART).requires((ItemLike)Items.REDSTONE_TORCH).unlockedBy("has_chest_minecart", StorageInMotionRecipeProvider.has((ItemLike)Items.CHEST_MINECART)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName("chest_minecart_to_storage_minecart"));
        this.addVanillaChestBoatConversionRecipes(recipeOutput);
        StorageInMotionRecipeProvider.addTierUpgradeRecipes(recipeOutput, ModItems.STORAGE_MINECART);
        StorageInMotionRecipeProvider.addTierUpgradeRecipes(recipeOutput, ModItems.STORAGE_BOAT);
    }

    private void addVanillaChestBoatConversionRecipes(RecipeOutput recipeOutput) {
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.OAK, Items.OAK_CHEST_BOAT);
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.SPRUCE, Items.SPRUCE_CHEST_BOAT);
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.BIRCH, Items.BIRCH_CHEST_BOAT);
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.JUNGLE, Items.JUNGLE_CHEST_BOAT);
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.ACACIA, Items.ACACIA_CHEST_BOAT);
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.DARK_OAK, Items.DARK_OAK_CHEST_BOAT);
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.MANGROVE, Items.MANGROVE_CHEST_BOAT);
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.BAMBOO, Items.BAMBOO_CHEST_RAFT);
        StorageInMotionRecipeProvider.addVanillaChestBoatConversionRecipe(recipeOutput, Boat.Type.CHERRY, Items.CHERRY_CHEST_BOAT);
    }

    private static void addVanillaChestBoatConversionRecipe(RecipeOutput recipeOutput, Boat.Type boatType, Item vanillaChestBoat) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemStack)MovingStorageItem.createWithStorage(StorageBoatItem.setBoatType(new ItemStack((ItemLike)ModItems.STORAGE_BOAT.get()), boatType), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), (WoodType)WoodType.OAK))).requires((ItemLike)vanillaChestBoat).requires((ItemLike)Items.REDSTONE_TORCH).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)vanillaChestBoat).getPath(), StorageInMotionRecipeProvider.has((ItemLike)vanillaChestBoat)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName(boatType.getName() + "_storage_" + (boatType.isRaft() ? "raft" : "boat") + "_from_vanilla"));
    }

    private void addStorageBoatFromStorageRecipes(RecipeOutput recipeOutput) {
        StorageBoatItem.SUPPORTED_BOAT_TYPES.forEach((boatType, baseBoat) -> ShapelessBasedRecipeBuilder.shapeless((ItemStack)StorageBoatItem.setBoatType(new ItemStack((ItemLike)ModItems.STORAGE_BOAT.get()), boatType), MovingStorageFromStorageRecipe::new).requires((ItemLike)baseBoat.get()).requires(ModBlocks.ALL_STORAGE_TAG).unlockedBy("has_sophisticated_storage", StorageInMotionRecipeProvider.has((TagKey)ModBlocks.ALL_STORAGE_TAG)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName(boatType.getName() + "_storage_" + (boatType.isRaft() ? "raft" : "boat"))));
    }

    private static void addTierUpgradeRecipes(RecipeOutput recipeOutput, Holder<Item> movingStorageItem) {
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.CHEST_ITEM.get(), (Item)ModBlocks.COPPER_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.BARREL_ITEM.get(), (Item)ModBlocks.COPPER_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.SHULKER_BOX_ITEM.get(), (Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        StorageInMotionRecipeProvider.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.COPPER_CHEST_ITEM.get(), (Item)ModBlocks.IRON_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.COPPER_BARREL_ITEM.get(), (Item)ModBlocks.IRON_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.CHEST_ITEM.get(), (Item)ModBlocks.IRON_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.BARREL_ITEM.get(), (Item)ModBlocks.IRON_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.SHULKER_BOX_ITEM.get(), (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.IRON_CHEST_ITEM.get(), (Item)ModBlocks.GOLD_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.IRON_BARREL_ITEM.get(), (Item)ModBlocks.GOLD_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), (Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.GOLD_CHEST_ITEM.get(), (Item)ModBlocks.DIAMOND_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.GOLD_BARREL_ITEM.get(), (Item)ModBlocks.DIAMOND_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), (Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        StorageInMotionRecipeProvider.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.DIAMOND_CHEST_ITEM.get(), (Item)ModBlocks.NETHERITE_CHEST_ITEM.get());
        StorageInMotionRecipeProvider.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.DIAMOND_BARREL_ITEM.get(), (Item)ModBlocks.NETHERITE_BARREL_ITEM.get());
        StorageInMotionRecipeProvider.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), (Item)ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get());
        StorageInMotionRecipeProvider.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get());
        StorageInMotionRecipeProvider.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get());
        StorageInMotionRecipeProvider.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get());
        StorageInMotionRecipeProvider.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get());
    }

    private static void addCheaperMovingStorageTierUpgradeRecipe(RecipeOutput recipeOutput, Holder<Item> movingStorageItem, Item storageItem, Item upgradedStorageItem, TagKey<Item> material) {
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, storageItem, upgradedStorageItem, material, builder -> builder.pattern(" M ").pattern("MSM").pattern(" M "));
    }

    private static void addMovingStorageTierUpgradeRecipe(RecipeOutput recipeOutput, Holder<Item> movingStorageItem, Item storageItem, Item upgradedStorageItem, TagKey<Item> material) {
        StorageInMotionRecipeProvider.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, storageItem, upgradedStorageItem, material, builder -> builder.pattern("MMM").pattern("MSM").pattern("MMM"));
    }

    private static void addMovingStorageTierUpgradeRecipe(RecipeOutput recipeOutput, Holder<Item> movingStorageItem, Item storageItem, Item upgradedStorageItem, TagKey<Item> material, UnaryOperator<ShapedRecipeBuilder> patternInit) {
        String storageItemPath = BuiltInRegistries.ITEM.getKey((Object)storageItem).getPath();
        ((ShapedRecipeBuilder)patternInit.apply((ShapedRecipeBuilder)ShapeBasedRecipeBuilder.shaped((ItemStack)MovingStorageItem.createWithStorage(new ItemStack((ItemLike)movingStorageItem.value()), new ItemStack((ItemLike)upgradedStorageItem)), MovingStorageTierUpgradeShapedRecipe::new))).define(Character.valueOf('S'), MovingStorageIngredient.of(movingStorageItem, storageItem).toVanilla()).define(Character.valueOf('M'), material).unlockedBy("has_" + storageItemPath, StorageInMotionRecipeProvider.has((ItemLike)storageItem)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName(movingStorageItem.getKey().location().getPath() + "_with_" + storageItemPath + "_to_" + BuiltInRegistries.ITEM.getKey((Object)upgradedStorageItem).getPath()));
    }

    private static void addMovingStorageDiamondToNetheriteTierUpgradeRecipe(RecipeOutput recipeOutput, Holder<Item> movingStorageItem, Item storageItem, Item upgradedStorageItem) {
        String storageItemPath = BuiltInRegistries.ITEM.getKey((Object)storageItem).getPath();
        ShapelessBasedRecipeBuilder.shapeless((ItemStack)MovingStorageItem.createWithStorage(new ItemStack((ItemLike)movingStorageItem.value()), new ItemStack((ItemLike)upgradedStorageItem)), MovingStorageTierUpgradeShapelessRecipe::new).requires(MovingStorageIngredient.of(movingStorageItem, storageItem).toVanilla()).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy("has_" + storageItemPath, StorageInMotionRecipeProvider.has((ItemLike)storageItem)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName(movingStorageItem.getKey().location().getPath() + "_with_" + storageItemPath + "_to_" + BuiltInRegistries.ITEM.getKey((Object)upgradedStorageItem).getPath()));
    }
}

