/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import com.mojang.serialization.DynamicOps;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui.StorageInMotionTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.StorageBoatItem;

public class StorageBoat
extends ChestBoat
implements IMovingStorageEntity {
    private static final EntityDataAccessor<Optional<Component>> DATA_CUSTOM_NAME = SynchedEntityData.defineId(StorageBoat.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_COMPONENT);
    static final EntityDataAccessor<ItemStack> DATA_STORAGE_ITEM = SynchedEntityData.defineId(StorageBoat.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    static final EntityDataAccessor<WoodType> DATA_WOOD_TYPE = SynchedEntityData.defineId(StorageBoat.class, ModEntities.WOOD_TYPE_SERIALIZER.get());
    private final EntityStorageHolder<StorageBoat> entityStorageHolder = new EntityStorageHolder<StorageBoat>(this);

    public StorageBoat(EntityType<StorageBoat> entityType, Level level) {
        super(entityType, level, () -> Items.ACACIA_BOAT);
    }

    public StorageBoat(Level level) {
        this(ModEntities.STORAGE_BOAT.get(), level);
    }

    public StorageBoat(Level level, double x, double y, double z) {
        this(level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STORAGE_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_CUSTOM_NAME, Optional.empty());
        builder.define(DATA_WOOD_TYPE, (Object)WoodType.OAK);
    }

    @Override
    public ItemStack getStorageItem() {
        return (ItemStack)this.entityData.get(DATA_STORAGE_ITEM);
    }

    @Override
    public void setStorageItem(ItemStack storageItem) {
        this.entityData.set(DATA_STORAGE_ITEM, (Object)storageItem.copy());
    }

    @Override
    public EntityStorageHolder<?> getStorageHolder() {
        return this.entityStorageHolder;
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource source, float amount) {
        return this.getStorageHolder().hurt(serverLevel, source, amount, (x$0, x$1, x$2) -> super.hurtServer(x$0, x$1, x$2));
    }

    public void destroy(ServerLevel serverLevel, DamageSource source) {
        this.kill(serverLevel);
        this.getStorageHolder().onDestroy();
    }

    @Override
    public ItemStack getDropStack(ItemStack storageItem) {
        ItemStack drop = this.getDropStack();
        drop.set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)storageItem));
        return drop;
    }

    private ItemStack getDropStack() {
        return StorageBoatItem.setWoodType(new ItemStack((ItemLike)ModItems.STORAGE_BOAT.get()), this.getWoodType());
    }

    public ItemStack getPickResult() {
        ItemStack result = this.getDropStack();
        ItemStack storageItemCopy = this.getStorageItem().copy();
        storageItemCopy.remove(ModCoreDataComponents.STORAGE_UUID);
        result.set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)storageItemCopy));
        return result;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("storageHolder", (Tag)this.entityStorageHolder.saveData((HolderLookup.Provider)this.level().registryAccess()));
        WoodType.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getWoodType()).ifSuccess(woodTypeTag -> tag.put("woodType", woodTypeTag));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityStorageHolder.readData((HolderLookup.Provider)this.level().registryAccess(), tag.getCompound("storageHolder"));
        if (tag.contains("woodType")) {
            Tag woodTag = tag.get("woodType");
            WoodType.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)woodTag).ifSuccess(woodType -> this.entityData.set(DATA_WOOD_TYPE, woodType));
        } else {
            this.entityData.set(DATA_WOOD_TYPE, (Object)WoodType.OAK);
        }
    }

    public void tick() {
        super.tick();
        this.entityStorageHolder.tick((Entity)this);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == DATA_STORAGE_ITEM && this.level().isClientSide()) {
            this.entityStorageHolder.onStorageItemSynced();
        }
    }

    public void setCustomName(@Nullable Component customName) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(customName));
    }

    private Component getWoodName(WoodType type) {
        return Component.translatable((String)("wood_name.sophisticatedstorage." + type.name().toLowerCase(Locale.ROOT)));
    }

    protected Component getTypeName() {
        String boatDescId = this.isRaft() ? "storage_raft" : "storage_boat";
        return Component.translatable((String)StorageInMotionTranslationHelper.INSTANCE.translEntity(boatDescId), (Object[])new Object[]{this.getWoodName(this.getWoodType()), this.getStorageItem().getHoverName()});
    }

    public WoodType getWoodType() {
        return (WoodType)this.entityData.get(DATA_WOOD_TYPE);
    }

    public void setWoodType(WoodType woodType) {
        this.entityData.set(DATA_WOOD_TYPE, (Object)woodType);
    }

    public boolean isRaft() {
        return this.getWoodType() == WoodType.BAMBOO;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult result;
        if (!player.isSecondaryUseActive() && (result = super.interact(player, hand)) != InteractionResult.PASS) {
            return result;
        }
        if (this.canAddPassenger((Entity)player) && !player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.getStorageHolder().openContainerMenu((Player)serverPlayer);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult interactWithContainerVehicle(Player player) {
        this.getStorageHolder().openMenu(player);
        return !player.level().isClientSide ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return this.getStorageHolder().createMenu(id, player);
    }

    public void openCustomInventoryScreen(Player player) {
        this.getStorageHolder().openContainerMenu(player);
    }

    public void remove(Entity.RemovalReason pReason) {
        this.setRemoved(pReason);
    }

    public int getContainerSize() {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().getSlots();
    }

    public NonNullList<ItemStack> getItemStacks() {
        return NonNullList.create();
    }

    public void addChestVehicleSaveData(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        this.getLootTable().ifPresent(lootTable -> {
            tag.putString("LootTable", lootTable.location().toString());
            if (this.getContainerLootTableSeed() != 0L) {
                tag.putLong("LootTableSeed", this.getContainerLootTableSeed());
            }
        });
    }

    public void readChestVehicleSaveData(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        this.clearItemStacks();
        if (tag.contains("LootTable", 8)) {
            this.setContainerLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.parse((String)tag.getString("LootTable"))));
            this.setContainerLootTableSeed(tag.getLong("LootTableSeed"));
        }
    }

    public void chestVehicleDestroyed(DamageSource damageSource, ServerLevel level, Entity p_entity) {
    }

    public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        InventoryHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryHandler();
        for (int slot = 0; slot < inventoryHandler.getSlots(); ++slot) {
            inventoryHandler.setStackInSlot(slot, ItemStack.EMPTY);
        }
    }

    public ItemStack removeChestVehicleItemNoUpdate(int slot) {
        ITrackedContentsItemHandler inventoryHandler = this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput();
        return inventoryHandler.extractItem(slot, inventoryHandler.getStackInSlot(slot).getCount(), false);
    }

    public ItemStack getChestVehicleItem(int slot) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().getStackInSlot(slot);
    }

    public ItemStack removeChestVehicleItem(int slot, int amount) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().extractItem(slot, amount, false);
    }

    public void setChestVehicleItem(int slot, ItemStack stack) {
        this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().setStackInSlot(slot, stack);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.getStorageHolder().getStorageWrapper().getInventoryForInputOutput().isItemValid(slot, stack);
    }

    public SlotAccess getChestVehicleSlot(int index) {
        return SlotAccess.NULL;
    }
}

