/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.data;

import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.common.Tags;
import net.p3pp3rf1y.sophisticatedcore.crafting.ShapeBasedRecipeBuilder;
import net.p3pp3rf1y.sophisticatedcore.crafting.ShapelessBasedRecipeBuilder;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageFromStorageRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageIngredient;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageTierUpgradeShapedRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.UncraftMovingStorageRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.StorageBoatItem;

public class StorageInMotionRecipeProvider
extends RecipeProvider {
    private final HolderLookup.RegistryLookup<Item> items;

    public StorageInMotionRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
        super(provider, recipeOutput);
        this.items = provider.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        SpecialRecipeBuilder.special(UncraftMovingStorageRecipe::new).save(this.output, SophisticatedStorageInMotion.getRegistryName("uncraft_moving_storage"));
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)ModItems.STORAGE_MINECART.get()), MovingStorageFromStorageRecipe::new).requires((ItemLike)Items.MINECART).requires(ModBlocks.ALL_STORAGE_TAG).unlockedBy("has_sophisticated_storage", this.has(ModBlocks.ALL_STORAGE_TAG)).save(this.output);
        this.addStorageBoatFromStorageRecipes(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)MovingStorageItem.createWithStorage(new ItemStack((ItemLike)ModItems.STORAGE_MINECART.get()), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), (WoodType)WoodType.OAK))).requires((ItemLike)Items.CHEST_MINECART).requires((ItemLike)Items.REDSTONE_TORCH).unlockedBy("has_chest_minecart", this.has((ItemLike)Items.CHEST_MINECART)).save(this.output, SophisticatedStorageInMotion.getRegistryName("chest_minecart_to_storage_minecart"));
        this.addVanillaChestBoatConversionRecipes(this.output);
        this.addTierUpgradeRecipes(this.output, (Holder<Item>)ModItems.STORAGE_MINECART);
        this.addTierUpgradeRecipes(this.output, (Holder<Item>)ModItems.STORAGE_BOAT);
    }

    private void addVanillaChestBoatConversionRecipes(RecipeOutput recipeOutput) {
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.OAK, Items.OAK_CHEST_BOAT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.SPRUCE, Items.SPRUCE_CHEST_BOAT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.BIRCH, Items.BIRCH_CHEST_BOAT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.JUNGLE, Items.JUNGLE_CHEST_BOAT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.ACACIA, Items.ACACIA_CHEST_BOAT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.DARK_OAK, Items.DARK_OAK_CHEST_BOAT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.MANGROVE, Items.MANGROVE_CHEST_BOAT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.BAMBOO, Items.BAMBOO_CHEST_RAFT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.CHERRY, Items.CHERRY_CHEST_BOAT);
        this.addVanillaChestBoatConversionRecipe(recipeOutput, WoodType.PALE_OAK, Items.PALE_OAK_CHEST_BOAT);
    }

    private void addVanillaChestBoatConversionRecipe(RecipeOutput recipeOutput, WoodType woodType, Item vanillaChestBoat) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemStack)MovingStorageItem.createWithStorage(StorageBoatItem.setWoodType(new ItemStack((ItemLike)ModItems.STORAGE_BOAT.get()), woodType), WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), (WoodType)WoodType.OAK))).requires((ItemLike)vanillaChestBoat).requires((ItemLike)Items.REDSTONE_TORCH).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)vanillaChestBoat).getPath(), this.has((ItemLike)vanillaChestBoat)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName(woodType.name() + "_storage_" + (woodType == WoodType.BAMBOO ? "raft" : "boat") + "_from_vanilla"));
    }

    private void addStorageBoatFromStorageRecipes(RecipeOutput recipeOutput) {
        StorageBoatItem.SUPPORTED_WOOD_TYPES.forEach((woodType, baseBoat) -> ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemStack)StorageBoatItem.setWoodType(new ItemStack((ItemLike)ModItems.STORAGE_BOAT.get()), woodType), MovingStorageFromStorageRecipe::new).requires((ItemLike)baseBoat.get()).requires(ModBlocks.ALL_STORAGE_TAG).unlockedBy("has_sophisticated_storage", this.has(ModBlocks.ALL_STORAGE_TAG)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName(woodType.name() + "_storage_" + (woodType == WoodType.BAMBOO ? "raft" : "boat"))));
    }

    private void addTierUpgradeRecipes(RecipeOutput recipeOutput, Holder<Item> movingStorageItem) {
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.CHEST_ITEM.get(), (Item)ModBlocks.COPPER_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.BARREL_ITEM.get(), (Item)ModBlocks.COPPER_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.SHULKER_BOX_ITEM.get(), (Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.COPPER_CHEST_ITEM.get(), (Item)ModBlocks.IRON_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.COPPER_BARREL_ITEM.get(), (Item)ModBlocks.IRON_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addCheaperMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.CHEST_ITEM.get(), (Item)ModBlocks.IRON_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.BARREL_ITEM.get(), (Item)ModBlocks.IRON_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.SHULKER_BOX_ITEM.get(), (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.IRON_CHEST_ITEM.get(), (Item)ModBlocks.GOLD_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.IRON_BARREL_ITEM.get(), (Item)ModBlocks.GOLD_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get(), (Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.GOLD_CHEST_ITEM.get(), (Item)ModBlocks.DIAMOND_CHEST_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.GOLD_BARREL_ITEM.get(), (Item)ModBlocks.DIAMOND_BARREL_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), (Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.DIAMOND_CHEST_ITEM.get(), (Item)ModBlocks.NETHERITE_CHEST_ITEM.get());
        this.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.DIAMOND_BARREL_ITEM.get(), (Item)ModBlocks.NETHERITE_BARREL_ITEM.get());
        this.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), (Item)ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get());
        this.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get());
        this.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get());
        this.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get());
        this.addMovingStorageDiamondToNetheriteTierUpgradeRecipe(recipeOutput, movingStorageItem, (Item)ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), (Item)ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get());
    }

    private void addCheaperMovingStorageTierUpgradeRecipe(RecipeOutput recipeOutput, Holder<Item> movingStorageItem, Item storageItem, Item upgradedStorageItem, TagKey<Item> material) {
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, storageItem, upgradedStorageItem, material, builder -> builder.pattern(" M ").pattern("MSM").pattern(" M "));
    }

    private void addMovingStorageTierUpgradeRecipe(RecipeOutput recipeOutput, Holder<Item> movingStorageItem, Item storageItem, Item upgradedStorageItem, TagKey<Item> material) {
        this.addMovingStorageTierUpgradeRecipe(recipeOutput, movingStorageItem, storageItem, upgradedStorageItem, material, builder -> builder.pattern("MMM").pattern("MSM").pattern("MMM"));
    }

    private void addMovingStorageTierUpgradeRecipe(RecipeOutput recipeOutput, Holder<Item> movingStorageItem, Item storageItem, Item upgradedStorageItem, TagKey<Item> material, UnaryOperator<ShapedRecipeBuilder> patternInit) {
        String storageItemPath = BuiltInRegistries.ITEM.getKey((Object)storageItem).getPath();
        ((ShapedRecipeBuilder)patternInit.apply((ShapedRecipeBuilder)ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)MovingStorageItem.createWithStorage(new ItemStack((ItemLike)movingStorageItem.value()), new ItemStack((ItemLike)upgradedStorageItem)), MovingStorageTierUpgradeShapedRecipe::new))).define(Character.valueOf('S'), MovingStorageIngredient.of(movingStorageItem, storageItem).toVanilla()).define(Character.valueOf('M'), material).unlockedBy("has_" + storageItemPath, this.has((ItemLike)storageItem)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName(movingStorageItem.getKey().location().getPath() + "_with_" + storageItemPath + "_to_" + BuiltInRegistries.ITEM.getKey((Object)upgradedStorageItem).getPath()));
    }

    private void addMovingStorageDiamondToNetheriteTierUpgradeRecipe(RecipeOutput recipeOutput, Holder<Item> movingStorageItem, Item storageItem, Item upgradedStorageItem) {
        String storageItemPath = BuiltInRegistries.ITEM.getKey((Object)storageItem).getPath();
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemStack)MovingStorageItem.createWithStorage(new ItemStack((ItemLike)movingStorageItem.value()), new ItemStack((ItemLike)upgradedStorageItem)), MovingStorageTierUpgradeShapelessRecipe::new).requires(MovingStorageIngredient.of(movingStorageItem, storageItem).toVanilla()).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy("has_" + storageItemPath, this.has((ItemLike)storageItem)).save(recipeOutput, SophisticatedStorageInMotion.getRegistryName(movingStorageItem.getKey().location().getPath() + "_with_" + storageItemPath + "_to_" + BuiltInRegistries.ITEM.getKey((Object)upgradedStorageItem).getPath()));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        protected Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(packOutput, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new StorageInMotionRecipeProvider(provider, recipeOutput);
        }

        public String getName() {
            return "Sophisticated Storage In Motion Recipes";
        }
    }
}

