/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageBoat;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class StorageBoatItem
extends MovingStorageItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private static final String RAFT_DESCRIPTION_ID = "item.sophisticatedstorageinmotion.storage_raft";
    public static final Map<WoodType, Supplier<Item>> SUPPORTED_WOOD_TYPES = Map.of(WoodType.ACACIA, () -> Items.ACACIA_BOAT, WoodType.BAMBOO, () -> Items.BAMBOO_RAFT, WoodType.BIRCH, () -> Items.BIRCH_BOAT, WoodType.CHERRY, () -> Items.CHERRY_BOAT, WoodType.DARK_OAK, () -> Items.DARK_OAK_BOAT, WoodType.JUNGLE, () -> Items.JUNGLE_BOAT, WoodType.MANGROVE, () -> Items.MANGROVE_BOAT, WoodType.OAK, () -> Items.OAK_BOAT, WoodType.PALE_OAK, () -> Items.PALE_OAK_BOAT, WoodType.SPRUCE, () -> Items.SPRUCE_BOAT);
    public static final DefaultDispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double yOffset;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = source.level();
            double halfWidth = 0.5625 + (double)ModEntities.STORAGE_BOAT.get().getWidth() / 2.0;
            Vec3 center = source.center();
            double x = center.x() + (double)direction.getStepX() * halfWidth;
            double y = center.y() + (double)direction.getStepY() * 1.125;
            double z = center.z() + (double)direction.getStepZ() * halfWidth;
            BlockPos blockpos = source.pos().relative(direction);
            StorageBoat boat = StorageBoatItem.createBoat((Level)level, null, stack, x, y, z);
            boat.setYRot(direction.toYRot());
            if (boat.canBoatInFluid(level.getFluidState(blockpos))) {
                yOffset = 1.0;
            } else {
                if (!level.getBlockState(blockpos).isAir() || !boat.canBoatInFluid(level.getFluidState(blockpos.below()))) {
                    return this.defaultDispenseItemBehavior.dispense(source, stack);
                }
                yOffset = 0.0;
            }
            boat.setPos(x, y + yOffset, z);
            level.addFreshEntity((Entity)boat);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };

    public StorageBoatItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public ItemStack getUncraftRemainingItem(ItemStack input) {
        return new ItemStack((ItemLike)SUPPORTED_WOOD_TYPES.getOrDefault(StorageBoatItem.getWoodType(input), () -> Items.OAK_BOAT).get());
    }

    @Override
    public List<ItemStack> getBaseMovingStorageItems() {
        return SUPPORTED_WOOD_TYPES.keySet().stream().map(type -> StorageBoatItem.setWoodType(new ItemStack((ItemLike)this), type)).toList();
    }

    public static WoodType getWoodType(ItemStack boatStack) {
        return (WoodType)boatStack.getOrDefault((DataComponentType)net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents.WOOD_TYPE.get(), (Object)WoodType.OAK);
    }

    public static ItemStack setWoodType(ItemStack boatStack, WoodType type) {
        boatStack.set((DataComponentType)net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents.WOOD_TYPE.get(), (Object)type);
        return boatStack;
    }

    @Override
    public Component getName(ItemStack stack) {
        SimpleItemContent storageItemContent = (SimpleItemContent)stack.get(ModDataComponents.STORAGE_ITEM);
        WoodType woodType = StorageBoatItem.getWoodType(stack);
        String descriptionId = woodType == WoodType.BAMBOO ? RAFT_DESCRIPTION_ID : this.getDescriptionId();
        return Component.translatable((String)descriptionId, (Object[])new Object[]{this.getWoodName(woodType), storageItemContent != null ? storageItemContent.copy().getHoverName() : ""});
    }

    private Component getWoodName(WoodType type) {
        return Component.translatable((String)("wood_name.sophisticatedstorage." + type.name().toLowerCase(Locale.ROOT)));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitresult = StorageBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        Vec3 playerViewVector = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(playerViewVector.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 eyePosition = player.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(eyePosition)) continue;
                return InteractionResult.PASS;
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            Vec3 location = hitresult.getLocation();
            StorageBoat boat = StorageBoatItem.createBoat(level, player, itemstack, location.x, location.y, location.z);
            if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResult.FAIL;
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitresult.getLocation());
                itemstack.consume(1, (LivingEntity)player);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static StorageBoat createBoat(Level level, @Nullable Player player, ItemStack stack, double x, double y, double z) {
        StorageBoat boat = new StorageBoat(level, x, y, z);
        EntityStorageHolder<?> storageHolder = boat.getStorageHolder();
        storageHolder.setStorageItemFromMovingStorage(stack, true);
        storageHolder.onPlace();
        boat.setWoodType(StorageBoatItem.getWoodType(stack));
        if (player != null) {
            boat.setYRot(player.getYRot());
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType.createDefaultStackConfig((Level)serverLevel, (ItemStack)stack, (LivingEntity)player).accept(boat);
        }
        return boat;
    }
}

