/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;

public abstract class MovingStorageItemRenderer<T extends Entity, D extends RenderData>
implements SpecialModelRenderer<D> {
    @Nullable
    private T movingStorage = null;

    public void render(@Nullable D data, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean hasFoil) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || data == null) {
            return;
        }
        T movingStorage = this.getMovingStorage(mc);
        this.setMovingStoragePropertiesFromData(movingStorage, data);
        ((IMovingStorageEntity)movingStorage).getStorageHolder().setStorageItemFrom(((RenderData)data).storageItem(), false);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        mc.getEntityRenderDispatcher().render(movingStorage, 0.0, 0.0, 0.0, 0.0f, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    protected abstract void setMovingStoragePropertiesFromData(T var1, D var2);

    private T getMovingStorage(Minecraft mc) {
        if (this.movingStorage == null) {
            this.movingStorage = this.instantiateMovingStorage(mc);
        }
        return this.movingStorage;
    }

    protected abstract T instantiateMovingStorage(Minecraft var1);

    public static class RenderData {
        private final ItemStack storageItem;

        public RenderData(ItemStack storageItem) {
            this.storageItem = storageItem;
        }

        public ItemStack storageItem() {
            return this.storageItem;
        }
    }
}

