/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageContentsPayload;

public class MovingStorageSettingsContainerMenu
extends SettingsContainerMenu<IStorageWrapper> {
    private final int entityId;
    private CompoundTag lastSettingsNbt = null;

    protected MovingStorageSettingsContainerMenu(int windowId, Player player, int entityId) {
        this(ModEntities.MOVING_STORAGE_SETTINGS_CONTAINER_TYPE.get(), windowId, player, entityId);
    }

    protected MovingStorageSettingsContainerMenu(MenuType<?> menuType, int windowId, Player player, int entityId) {
        super(menuType, windowId, player, MovingStorageSettingsContainerMenu.getWrapper(player.level(), entityId));
        this.entityId = entityId;
    }

    private static IStorageWrapper getWrapper(Level level, int entityId) {
        Entity entity = level.getEntity(entityId);
        if (!(entity instanceof IMovingStorageEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)entity;
        return movingStorageEntity.getStorageHolder().getStorageWrapper();
    }

    public void detectSettingsChangeAndReload() {
        if (this.player.level().isClientSide) {
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                MovingStorageData storage = MovingStorageData.get();
                if (storage.removeUpdatedStorageSettingsFlag((UUID)uuid)) {
                    this.storageWrapper.getSettingsHandler().reloadFrom(storage.getContents((UUID)uuid).getCompoundOrEmpty("settings"));
                }
            });
        }
    }

    public static MovingStorageSettingsContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new MovingStorageSettingsContainerMenu(windowId, playerInventory.player, buffer.readInt());
    }

    public int getEntityId() {
        return this.entityId;
    }

    private void sendStorageSettingsToClient() {
        if (this.player.level().isClientSide) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.storageWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.storageWrapper.getSettingsHandler().getNbt().copy();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = this.storageWrapper.getSettingsHandler().getNbt();
                if (!settingsNbt.isEmpty()) {
                    settingsContents.put("settings", (Tag)settingsNbt);
                    Player patt0$temp = this.player;
                    if (patt0$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MovingStorageContentsPayload((UUID)uuid, settingsContents), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            });
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.sendStorageSettingsToClient();
    }
}

