/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.HighlightRequestPayloadHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.common.IHighlightRequestPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.ITintable;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderToolHandler;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.PackingTapeItem;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.MovingStorageHighlightRequestPayloadHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.TierUpgradeHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class CommonEventHandler {
    private CommonEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(CommonEventHandler::onMovingStorageUncrafted);
        eventBus.addListener(CommonEventHandler::onMovingStorageCraftedFromShulkerBox);
        eventBus.addListener(TierUpgradeHandler::onTierUpgradeInteract);
        eventBus.addListener(CommonEventHandler::onStorageToolInteract);
        eventBus.addListener(CommonEventHandler::onPacked);
        eventBus.addListener(CommonEventHandler::onPaintbrushInteract);
        eventBus.addListener(CommonEventHandler::onStorageUpgradeInteract);
        CommonEventHandler.registerHighlightRequestPayloadHandler();
    }

    private static void registerHighlightRequestPayloadHandler() {
        HighlightRequestPayloadHandlerRegistry.register((IHighlightRequestPayloadHandler)MovingStorageHighlightRequestPayloadHandler.INSTANCE);
    }

    private static void onStorageUpgradeInteract(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorage;
        ItemStack itemInHand;
        Player player;
        block5: {
            block4: {
                player = event.getEntity();
                itemInHand = player.getItemInHand(event.getHand());
                Entity entity = event.getTarget();
                if (!(entity instanceof IMovingStorageEntity)) break block4;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.getItem() instanceof UpgradeItemBase) break block5;
            }
            return;
        }
        if (StorageBlockBase.tryAddSingleUpgrade((Player)player, (ItemStack)itemInHand, (IStorageWrapper)movingStorage.getStorageHolder().getStorageWrapper()).consumesAction()) {
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
        }
    }

    private static void onPaintbrushInteract(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorage;
        ItemStack itemInHand;
        Player player;
        block6: {
            block5: {
                player = event.getEntity();
                itemInHand = player.getItemInHand(event.getHand());
                Entity entity = event.getTarget();
                if (!(entity instanceof IMovingStorageEntity)) break block5;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.getItem() == ModItems.PAINTBRUSH.get()) break block6;
            }
            return;
        }
        Item item = movingStorage.getStorageItem().getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.getBlock().defaultBlockState();
        SoundEvent placeSound = state.getBlock().getSoundType(state, (LevelReader)player.level(), BlockPos.ZERO, (Entity)player).getPlaceSound();
        if (PaintbrushItem.paint((Player)player, (ItemStack)itemInHand, movingStorage.getStorageHolder(), (ITintable)movingStorage.getStorageHolder().getStorageWrapper(), (Vec3)event.getTarget().position(), (Direction)Direction.UP, (SoundEvent)placeSound)) {
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
        }
    }

    private static void onPacked(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorage;
        ItemStack itemInHand;
        Player player;
        block7: {
            block6: {
                player = event.getEntity();
                itemInHand = player.getItemInHand(event.getHand());
                Entity entity = event.getTarget();
                if (!(entity instanceof IMovingStorageEntity)) break block6;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.getItem() instanceof PackingTapeItem && !((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) break block7;
            }
            return;
        }
        if (movingStorage.getStorageHolder().pack()) {
            if (!player.isCreative()) {
                itemInHand.setDamageValue(itemInHand.getDamageValue() + 1);
                if (itemInHand.getDamageValue() >= itemInHand.getMaxDamage()) {
                    player.setItemInHand(event.getHand(), ItemStack.EMPTY);
                }
            }
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
        }
    }

    private static void onMovingStorageUncrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack result = event.getCrafting();
        if (event.getEntity().level().isClientSide() || !(result.getItem() instanceof StorageBlockItem) || !CommonEventHandler.isUncraftedFromSingleMovingStorage(event.getInventory())) {
            return;
        }
        UUID storageId = (UUID)result.get(ModCoreDataComponents.STORAGE_UUID);
        if (storageId == null) {
            return;
        }
        MovingStorageData.moveToItemStorage(result, storageId);
    }

    private static boolean isUncraftedFromSingleMovingStorage(Container inventory) {
        boolean hasMovingStorage = false;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!hasMovingStorage && stack.getItem() instanceof MovingStorageItem) {
                hasMovingStorage = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static void onMovingStorageCraftedFromShulkerBox(PlayerEvent.ItemCraftedEvent event) {
        Level level = event.getEntity().level();
        ItemStack result = event.getCrafting();
        if (level.isClientSide()) {
            return;
        }
        if (!CommonEventHandler.isCraftedFromShulkerBox(event.getInventory())) {
            return;
        }
        ItemStack storageItem = MovingStorageItem.getStorageItem(result);
        if (storageItem.getItem() instanceof ShulkerBoxItem) {
            StackStorageWrapper shulkerStorageWrapper = StackStorageWrapper.fromStack((HolderLookup.Provider)level.registryAccess(), (ItemStack)storageItem);
            shulkerStorageWrapper.getContentsUuid().ifPresent(id -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                CompoundTag contentsNbt = itemContentsStorage.getOrCreateStorageContents(id).getCompoundOrEmpty("storageWrapper");
                CompoundTag migratedContentsNbt = new CompoundTag();
                migratedContentsNbt.put("contents", (Tag)contentsNbt.getCompoundOrEmpty("contents"));
                migratedContentsNbt.put("settings", (Tag)contentsNbt.getCompoundOrEmpty("settings"));
                MovingStorageData.get().setContents((UUID)id, migratedContentsNbt);
                storageItem.set(ModCoreDataComponents.RENDER_INFO_TAG, (Object)CustomData.of((CompoundTag)contentsNbt.getCompoundOrEmpty("renderInfo")));
                MovingStorageItem.setStorageItem(result, storageItem);
                itemContentsStorage.removeStorageContents(id);
            });
            MovingStorageItem.setStorageItem(result, storageItem);
        }
    }

    private static boolean isCraftedFromShulkerBox(Container craftingGrid) {
        boolean foundShulker = false;
        for (int slot = 0; slot < craftingGrid.getContainerSize(); ++slot) {
            if (!(craftingGrid.getItem(slot).getItem() instanceof ShulkerBoxItem)) continue;
            foundShulker = true;
        }
        return foundShulker;
    }

    public static void onStorageToolInteract(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorageEntity;
        ItemStack itemInHand;
        block5: {
            block4: {
                Player player = event.getEntity();
                itemInHand = player.getItemInHand(event.getHand());
                Entity entity = event.getTarget();
                if (!(entity instanceof IMovingStorageEntity)) break block4;
                movingStorageEntity = (IMovingStorageEntity)entity;
                if (itemInHand.getItem() == ModItems.STORAGE_TOOL.get() && !movingStorageEntity.getStorageHolder().isPacked()) break block5;
            }
            return;
        }
        InteractionResult result = StorageHolderToolHandler.tryStorageToolInteract((ItemStack)itemInHand, movingStorageEntity.getStorageHolder());
        if (result.consumesAction()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }
}

