/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.mixin;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui.StorageInMotionTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IStorageItemAttachmentHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractChestedHorse.class})
public abstract class MixinAbstractChestedHorse
extends AbstractHorse
implements IMovingStorageEntity,
IStorageItemAttachmentHolder {
    private static final ResourceLocation SADDLE_SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot/saddle");
    private static final ResourceLocation LLAMA_ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot/llama_armor");
    private static final String STORAGE_HOLDER = "storageHolder";
    @Unique
    private final EntityStorageHolder<MixinAbstractChestedHorse> entityStorageHolder = new EntityStorageHolder<MixinAbstractChestedHorse>(this);
    private boolean storageItemSynced = false;

    @Shadow
    public abstract boolean hasChest();

    protected MixinAbstractChestedHorse(EntityType<? extends AbstractChestedHorse> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    protected abstract void playChestEquipsSound();

    @Inject(method={"dropEquipment"}, at={@At(value="TAIL")})
    private void dropStorageAndItsContents(ServerLevel serverLevel, CallbackInfo ci) {
        this.entityStorageHolder.onDestroy();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addStorageHolderSaveData(ValueOutput out, CallbackInfo ci) {
        if (this.hasStorageItem()) {
            out.putChild(STORAGE_HOLDER, this.entityStorageHolder);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readStorageHolderSaveData(ValueInput in, CallbackInfo ci) {
        in.child(STORAGE_HOLDER).ifPresent(this.entityStorageHolder::deserialize);
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isTamed() && stack.getItem() instanceof StorageBlockItem && !this.hasStorageItem() && !this.hasChest()) {
            ItemStack stackCopy = stack.copyWithCount(1);
            this.entityStorageHolder.setStorageItemFrom(stackCopy, true);
            this.playChestEquipsSound();
            stack.consume(1, (LivingEntity)player);
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        } else if (this.isTamed() && this.hasStorageItem() && stack.is(Items.CHEST)) {
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Override
    public List<Slot> instantiateExtraSlots() {
        if (this.canUseSlot(EquipmentSlot.BODY) && (this.getType().is(EntityTypeTags.CAN_WEAR_HORSE_ARMOR) || this instanceof Llama)) {
            Container container = this.createEquipmentSlotContainer(EquipmentSlot.BODY);
            return List.of(new ArmorSlot(container, (LivingEntity)this, EquipmentSlot.BODY, 0, 8, 36, (ResourceLocation)(this instanceof Llama ? LLAMA_ARMOR_SLOT_SPRITE : null)){

                public boolean mayPlace(ItemStack stack) {
                    return MixinAbstractChestedHorse.this.isEquippableInSlot(stack, EquipmentSlot.BODY);
                }
            });
        }
        if (this.canUseSlot(EquipmentSlot.SADDLE) && this.getType().is(EntityTypeTags.CAN_EQUIP_SADDLE)) {
            Container container = this.createEquipmentSlotContainer(EquipmentSlot.SADDLE);
            return List.of(new ArmorSlot(container, (LivingEntity)this, EquipmentSlot.SADDLE, 0, 0, 0, SADDLE_SLOT_SPRITE){

                public boolean mayPlace(ItemStack stack) {
                    return stack.is(Items.SADDLE) && !this.hasItem() && MixinAbstractChestedHorse.this.canUseSlot(EquipmentSlot.SADDLE) && MixinAbstractChestedHorse.this.getType().is(EntityTypeTags.CAN_EQUIP_SADDLE);
                }
            });
        }
        return Collections.emptyList();
    }

    private boolean hasStorageItem() {
        return !this.getStorageItem().isEmpty();
    }

    @Override
    public ItemStack getStorageItem() {
        return (ItemStack)this.getData(ModEntities.STORAGE_ITEM_ATTACHMENT);
    }

    @Override
    public void setStorageItem(ItemStack storageItem) {
        this.setData(ModEntities.STORAGE_ITEM_ATTACHMENT, storageItem);
    }

    @Override
    public EntityStorageHolder<?> getStorageHolder() {
        return this.entityStorageHolder;
    }

    @Override
    public ItemStack getDropStack(ItemStack storageItem) {
        UUID storageId = (UUID)storageItem.get(ModCoreDataComponents.STORAGE_UUID);
        if (storageId != null) {
            MovingStorageData.moveToItemStorage(storageItem, storageId);
        }
        return storageItem;
    }

    public void tick() {
        super.tick();
        if (this.storageItemSynced) {
            this.storageItemSynced = false;
            this.entityStorageHolder.onStorageItemSynced();
        }
        if (this.hasStorageItem()) {
            this.entityStorageHolder.tick((Entity)this);
        }
    }

    protected Component getTypeName() {
        if (this.hasStorageItem()) {
            return Component.translatable((String)StorageInMotionTranslationHelper.INSTANCE.translEntity("chested_horse_with_storage"), (Object[])new Object[]{super.getTypeName(), this.getStorageItem().getHoverName()});
        }
        return super.getTypeName();
    }

    @Override
    public void markStorageItemSynced() {
        this.storageItemSynced = true;
    }
}

