/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.StaticBlockEntityTintGetter;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;

public class StorageBlockRenderer {
    private static final Map<Class<? extends AbstractChestedHorse>, Function<StorageBlockEntity, Vec3>> OFFSET_MAP = new LinkedHashMap<Class<? extends AbstractChestedHorse>, Function<StorageBlockEntity, Vec3>>();
    private static final Function<StorageBlockEntity, Vec3> DEFAULT_OFFSET;

    public static void renderStorageBlock(float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, StorageBlockEntity renderBlockEntity) {
        BlockEntityRenderer renderer;
        BlockState state = renderBlockEntity.m_58900_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (renderBlockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)renderBlockEntity;
            BlockRenderDispatcher blockRenderer = minecraft.m_91289_();
            BakedModel bakedModel = blockRenderer.m_110910_(barrel.m_58900_());
            ModelData modelData = BarrelBakedModelBase.getModelDataFromBlockEntity((BarrelBlockEntity)barrel);
            StaticBlockEntityTintGetter wrappedLevel = new StaticBlockEntityTintGetter((BlockAndTintGetter)minecraft.f_91073_, (BlockEntity)renderBlockEntity, packedLight);
            for (RenderType renderType : bakedModel.getRenderTypes(state, RandomSource.m_216335_((long)42L), modelData)) {
                VertexConsumer vertexConsumer = buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false));
                RandomSource randomsource = RandomSource.m_216327_();
                randomsource.m_188584_(42L);
                blockRenderer.m_110937_().tesselateWithoutAO((BlockAndTintGetter)wrappedLevel, bakedModel, barrel.m_58900_(), BlockPos.f_121853_, poseStack, vertexConsumer, false, randomsource, state.m_60726_(BlockPos.f_121853_), OverlayTexture.f_118083_, modelData, renderType);
            }
        }
        if ((renderer = minecraft.m_167982_().m_112265_((BlockEntity)renderBlockEntity)) != null) {
            renderer.m_6922_((BlockEntity)renderBlockEntity, partialTicks, poseStack, buffer, packedLight, OverlayTexture.f_118083_);
        }
    }

    public static void renderChestedHorseStorage(float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractChestedHorse chestedHorse, IMovingStorageEntity movingStorage) {
        EntityStorageHolder<?> storageHolder = movingStorage.getStorageHolder();
        StorageBlockEntity renderBlockEntity = storageHolder.getRenderBlockEntity();
        if (renderBlockEntity == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        Function<StorageBlockEntity, Vec3> offsetFunction = OFFSET_MAP.getOrDefault(chestedHorse.getClass(), DEFAULT_OFFSET);
        if (offsetFunction != null) {
            poseStack.m_85837_(offsetFunction.apply((StorageBlockEntity)renderBlockEntity).f_82479_, offsetFunction.apply((StorageBlockEntity)renderBlockEntity).f_82480_, offsetFunction.apply((StorageBlockEntity)renderBlockEntity).f_82481_);
        }
        StorageBlockRenderer.renderStorageOnSide(chestedHorse, poseStack, 90, 1.0f, renderBlockEntity, packedLight, buffer, partialTicks);
        StorageBlockRenderer.renderStorageOnSide(chestedHorse, poseStack, 270, -1.0f, renderBlockEntity, packedLight, buffer, partialTicks);
        poseStack.m_85849_();
    }

    private static void renderStorageOnSide(AbstractChestedHorse chestedHorse, PoseStack poseStack, int storageRotation, float xOffsetMultiplier, StorageBlockEntity renderBlockEntity, int packedLight, MultiBufferSource buffer, float partialTick) {
        float halftWidth = chestedHorse.m_20205_() / 2.0f;
        poseStack.m_85836_();
        float scale = 0.57f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(Axis.f_252392_.m_252977_((float)storageRotation));
        float xOffset = halftWidth * 0.49f * xOffsetMultiplier;
        float sideOffset = chestedHorse instanceof Llama ? (renderBlockEntity instanceof ChestBlockEntity ? 1.0f : 0.85f) : (renderBlockEntity instanceof ChestBlockEntity ? 0.6f : 0.5f);
        float zOffset = -halftWidth * sideOffset;
        double yOffset = renderBlockEntity instanceof ChestBlockEntity ? (double)(chestedHorse.m_20206_() * 1.03f) : (double)(chestedHorse.m_20206_() * 1.01f);
        poseStack.m_85837_((double)xOffset, yOffset, (double)zOffset);
        if (!(renderBlockEntity instanceof ChestBlockEntity)) {
            poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        StorageBlockRenderer.renderStorageBlock(partialTick, poseStack, buffer, packedLight, renderBlockEntity);
        poseStack.m_85849_();
    }

    static {
        OFFSET_MAP.put(Donkey.class, renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? new Vec3(0.0, -1.283, -0.515) : new Vec3(0.0, -1.34, -0.48));
        OFFSET_MAP.put(Mule.class, renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? new Vec3(0.0, -1.343, -0.515) : new Vec3(0.0, -1.4, -0.48));
        OFFSET_MAP.put(Llama.class, renderBlockEntity -> new Vec3(0.0, -1.5, -0.25));
        OFFSET_MAP.put(AbstractChestedHorse.class, renderBlockEntity -> new Vec3(0.0, -1.5, -0.25));
        DEFAULT_OFFSET = renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? new Vec3(0.0, -1.343, -0.515) : new Vec3(0.0, -1.4, -0.48);
    }
}

