/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageContentsMessage;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.StorageInMotionPacketHandler;

public class MovingStorageContainerMenu<T extends Entity>
extends StorageContainerMenuBase<IStorageWrapper>
implements ISyncedContainer {
    protected final WeakReference<T> storageEntity;
    @Nullable
    private CompoundTag lastSettingsNbt = null;

    public MovingStorageContainerMenu(int containerId, Player player, int entityId) {
        this((MenuType)ModEntities.MOVING_STORAGE_CONTAINER_TYPE.get(), containerId, player, entityId);
    }

    public MovingStorageContainerMenu(MenuType<?> menuType, int containerId, Player player, int entityId) {
        super(menuType, containerId, player, MovingStorageContainerMenu.getWrapper(player.m_9236_(), entityId), (IStorageWrapper)NoopStorageWrapper.INSTANCE, -1, false, MovingStorageContainerMenu.instantiateExtraSlots(player.m_9236_(), entityId));
        Entity entity = player.m_9236_().m_6815_(entityId);
        if (!(entity instanceof IMovingStorageEntity)) {
            throw new IllegalArgumentException("Incorrect entity with id " + entityId + " expected to find IMovingStorageEntity");
        }
        IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)entity;
        this.storageEntity = new WeakReference<Entity>((Entity)movingStorageEntity);
        movingStorageEntity.getStorageHolder().startOpen(player, (Entity)this.storageEntity.get());
    }

    private static List<Slot> instantiateExtraSlots(Level level, int entityId) {
        Entity entity = level.m_6815_(entityId);
        if (!(entity instanceof IMovingStorageEntity)) {
            return Collections.emptyList();
        }
        IMovingStorageEntity movingStorage = (IMovingStorageEntity)entity;
        return movingStorage.instantiateExtraSlots();
    }

    public Optional<T> getStorageEntity() {
        return Optional.ofNullable((Entity)this.storageEntity.get());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.getStorageEntity().ifPresent(storageEntity -> ((IMovingStorageEntity)storageEntity).getStorageHolder().stopOpen(player, (Entity)storageEntity));
    }

    private static IStorageWrapper getWrapper(Level level, int entityId) {
        Entity entity = level.m_6815_(entityId);
        if (!(entity instanceof IMovingStorageEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        IMovingStorageEntity movingStorage = (IMovingStorageEntity)entity;
        return movingStorage.getStorageHolder().getStorageWrapper();
    }

    public static MovingStorageContainerMenu<?> fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new MovingStorageContainerMenu(windowId, playerInventory.f_35978_, buffer.readInt());
    }

    public Optional<BlockPos> getBlockPosition() {
        return Optional.empty();
    }

    public Optional<Entity> getEntity() {
        return this.getStorageEntity().map(e -> e);
    }

    protected StorageContainerMenuBase.StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
        return new StorageContainerMenuBase.StorageUpgradeSlot(upgradeHandler, slotIndex){

            protected void onUpgradeChanged() {
                if (MovingStorageContainerMenu.this.player.m_9236_().m_5776_()) {
                    return;
                }
                ((ItemDisplaySettingsCategory)MovingStorageContainerMenu.this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }
        };
    }

    public void openSettings() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            this.sendToServer(data -> data.m_128359_("action", "openSettings"));
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        this.getStorageEntity().ifPresent(entity -> NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.instantiateSettingsContainerMenu(w, pl, entity.m_19879_()), (Component)Component.m_237115_((String)StorageTranslationHelper.INSTANCE.translGui("settings.title"))), buffer -> buffer.writeInt(entity.m_19879_())));
    }

    protected MovingStorageSettingsContainerMenu instantiateSettingsContainerMenu(int windowId, Player player, int entityId) {
        return new MovingStorageSettingsContainerMenu(windowId, player, entityId);
    }

    protected boolean storageItemHasChanged() {
        return false;
    }

    public boolean detectSettingsChangeAndReload() {
        if (this.player.m_9236_().f_46443_) {
            return this.storageWrapper.getContentsUuid().map(uuid -> {
                MovingStorageData storage = MovingStorageData.get(uuid);
                if (storage.removeUpdatedStorageSettingsFlag((UUID)uuid)) {
                    this.storageWrapper.getSettingsHandler().reloadFrom(storage.getContents().m_128469_("settings"));
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return this.getStorageEntity().map(se -> player.m_20238_(se.m_20182_()) <= 64.0).orElse(false);
    }

    protected void sendStorageSettingsToClient() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.storageWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.storageWrapper.getSettingsHandler().getNbt().m_6426_();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = this.storageWrapper.getSettingsHandler().getNbt();
                if (!settingsNbt.m_128456_()) {
                    settingsContents.m_128365_("settings", (Tag)settingsNbt);
                    Player patt6712$temp = this.player;
                    if (patt6712$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt6712$temp;
                        StorageInMotionPacketHandler.INSTANCE.sendToClient(serverPlayer, new MovingStorageContentsMessage((UUID)uuid, settingsContents));
                    }
                }
            });
        }
    }

    public float getSlotFillPercentage(int slot) {
        IMovingStorageEntity entity = (IMovingStorageEntity)this.storageEntity.get();
        if (entity == null) {
            return 0.0f;
        }
        List slotFillRatios = entity.getStorageHolder().getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotFillRatios();
        return slot > -1 && slot < slotFillRatios.size() ? ((Float)slotFillRatios.get(slot)).floatValue() : 0.0f;
    }
}

