/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageContentsMessage;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.StorageInMotionPacketHandler;

public class MovingStorageSettingsContainerMenu
extends SettingsContainerMenu<IStorageWrapper> {
    private final int entityId;
    private CompoundTag lastSettingsNbt = null;

    protected MovingStorageSettingsContainerMenu(int windowId, Player player, int entityId) {
        this((MenuType)ModEntities.MOVING_STORAGE_SETTINGS_CONTAINER_TYPE.get(), windowId, player, entityId);
    }

    protected MovingStorageSettingsContainerMenu(MenuType<?> menuType, int windowId, Player player, int entityId) {
        super(menuType, windowId, player, MovingStorageSettingsContainerMenu.getWrapper(player.m_9236_(), entityId));
        this.entityId = entityId;
    }

    private static IStorageWrapper getWrapper(Level level, int entityId) {
        Entity entity = level.m_6815_(entityId);
        if (!(entity instanceof IMovingStorageEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)entity;
        return movingStorageEntity.getStorageHolder().getStorageWrapper();
    }

    public void detectSettingsChangeAndReload() {
        if (this.player.m_9236_().f_46443_) {
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                MovingStorageData storage = MovingStorageData.get(uuid);
                if (storage.removeUpdatedStorageSettingsFlag((UUID)uuid)) {
                    this.storageWrapper.getSettingsHandler().reloadFrom(storage.getContents().m_128469_("settings"));
                }
            });
        }
    }

    public static MovingStorageSettingsContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new MovingStorageSettingsContainerMenu(windowId, playerInventory.f_35978_, buffer.readInt());
    }

    public int getEntityId() {
        return this.entityId;
    }

    private void sendStorageSettingsToClient() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.storageWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.storageWrapper.getSettingsHandler().getNbt().m_6426_();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = this.storageWrapper.getSettingsHandler().getNbt();
                if (!settingsNbt.m_128456_()) {
                    settingsContents.m_128365_("settings", (Tag)settingsNbt);
                    Player patt3196$temp = this.player;
                    if (patt3196$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt3196$temp;
                        StorageInMotionPacketHandler.INSTANCE.sendToClient(serverPlayer, new MovingStorageContentsMessage((UUID)uuid, settingsContents));
                    }
                }
            });
        }
    }

    public void m_38946_() {
        super.m_38946_();
        this.sendStorageSettingsToClient();
    }
}

