/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingLimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.ItemNBTHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageOpennessMessage;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.StorageInMotionPacketHandler;

public class EntityStorageHolder<T extends Entity>
extends StorageHolderBase {
    public static final String STORAGE_ITEM_TAG = "storageItem";
    private static final int AVERAGE_DROPPED_ITEM_ENTITY_STACK_SIZE = 20;
    private final T entity;
    @Nullable
    private StorageBlockEntity renderBlockEntity = null;

    public EntityStorageHolder(T entity) {
        super(!(entity instanceof AbstractChestedHorse));
        this.entity = entity;
    }

    protected Entity getEntity() {
        return this.entity;
    }

    protected boolean isOwnContainer(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof MovingStorageContainerMenu) {
            MovingStorageContainerMenu movingStorageContainerMenu = (MovingStorageContainerMenu)abstractContainerMenu;
            return movingStorageContainerMenu.getStorageEntity().map(e -> e == this.entity).orElse(false);
        }
        return false;
    }

    public void setStorageItemFromMovingStorage(ItemStack movingStorageStack, boolean setupDefaults) {
        ItemStack storageItem = NBTHelper.getCompound((ItemStack)movingStorageStack, (String)STORAGE_ITEM_TAG).map(ItemStack::m_41712_).orElse(ItemStack.f_41583_);
        if (storageItem.m_41619_()) {
            ItemStack barrel = new ItemStack((ItemLike)ModBlocks.BARREL_ITEM.get());
            WoodStorageBlockItem.setWoodType((ItemStack)barrel, (WoodType)WoodType.f_61831_);
            this.setStorageItem(barrel);
        } else {
            this.setStorageItemFrom(storageItem, setupDefaults);
        }
    }

    protected float getUpgradeRenderYOffset() {
        if (this.entity instanceof AbstractChestedHorse) {
            return 1.2f;
        }
        return super.getUpgradeRenderYOffset();
    }

    public void setStorageItemFrom(ItemStack storageItem, boolean setupDefaults) {
        this.setStorageItem(storageItem);
        if (setupDefaults && MovingStorageWrapper.isLimitedBarrel((ItemStack)storageItem)) {
            int n;
            IStorageWrapper iStorageWrapper;
            IStorageWrapper iStorageWrapper2 = iStorageWrapper = this.getStorageWrapper();
            if (iStorageWrapper instanceof MovingStorageWrapper) {
                MovingStorageWrapper movingStorageWrapper = (MovingStorageWrapper)iStorageWrapper;
                n = movingStorageWrapper.getNumberOfInventorySlots();
            } else {
                n = this.getStorageWrapper().getInventoryHandler().getSlots();
            }
            LimitedBarrelBlockEntity.setFixedSettings((IStorageWrapper)iStorageWrapper2, (int)n);
            LimitedBarrelBlock.setupDefaultSettings((IStorageWrapper)this.getStorageWrapper());
        }
    }

    public CompoundTag saveData() {
        CompoundTag ret = new CompoundTag();
        ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        if (!storageItem.m_41619_()) {
            ret.m_128365_(STORAGE_ITEM_TAG, (Tag)storageItem.m_41739_(new CompoundTag()));
        }
        return ret;
    }

    public void readData(CompoundTag tag) {
        if (tag.m_128441_(STORAGE_ITEM_TAG)) {
            this.setStorageItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_(STORAGE_ITEM_TAG)));
        }
    }

    private void setRenderBlockEntity(StorageBlockEntity storageBlockEntity) {
        this.renderBlockEntity = storageBlockEntity;
    }

    protected void setSyncedStorageStack(ItemStack storageStack) {
        ((IMovingStorageEntity)this.entity).setStorageItem(storageStack);
    }

    protected ItemStack getSyncedStorageStack() {
        return ((IMovingStorageEntity)this.entity).getStorageItem();
    }

    protected IStorageSavedData getStorageData(UUID storageId) {
        return MovingStorageData.get(storageId);
    }

    public boolean isLocked(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"locked").orElse(false);
    }

    @Nullable
    protected Level getLevel() {
        return this.entity.m_9236_();
    }

    protected Vec3 getPosition() {
        return this.entity.m_20182_();
    }

    protected void sendOpenness(Entity entity) {
        StorageInMotionPacketHandler.INSTANCE.sendToAllTracking(new MovingStorageOpennessMessage(entity.m_19879_(), this.isOpen()), entity);
    }

    @Nullable
    protected StorageBlockEntity retrieveRenderBlockEntity() {
        ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        if (this.renderBlockEntity == null) {
            Item item = storageItem.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (blockItem.m_40614_() instanceof ChestBlock) {
                    this.renderBlockEntity = new ChestBlockEntity(BlockPos.f_121853_, blockItem.m_40614_().m_49966_());
                } else if (blockItem.m_40614_() instanceof LimitedBarrelBlock) {
                    this.renderBlockEntity = new LimitedBarrelBlockEntity(BlockPos.f_121853_, (BlockState)((BlockState)blockItem.m_40614_().m_49966_().m_61124_((Property)LimitedBarrelBlock.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LimitedBarrelBlock.VERTICAL_FACING, (Comparable)VerticalFacing.UP));
                } else if (blockItem.m_40614_() instanceof BarrelBlock) {
                    this.renderBlockEntity = new BarrelBlockEntity(BlockPos.f_121853_, (BlockState)blockItem.m_40614_().m_49966_().m_61124_((Property)BarrelBlock.FACING, (Comparable)Direction.UP));
                } else if (blockItem.m_40614_() instanceof ShulkerBoxBlock) {
                    this.renderBlockEntity = new ShulkerBoxBlockEntity(BlockPos.f_121853_, blockItem.m_40614_().m_49966_());
                }
            }
            if (this.renderBlockEntity == null) {
                this.renderBlockEntity = new ChestBlockEntity(BlockPos.f_121853_, ((ChestBlock)ModBlocks.CHEST.get()).m_49966_());
            }
            this.setRenderBlockEntity(this.renderBlockEntity);
            this.renderBlockEntity.m_142339_(this.entity.m_9236_());
        }
        return this.renderBlockEntity;
    }

    public void onDestroy() {
        if (this.entity.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) {
                this.pack();
            }
            ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
            if (!this.isShulkerBox() && !this.isPacked(storageItem)) {
                this.dropAllItems();
                ItemStack finalStorageItem = storageItem;
                storageItem = NBTHelper.getUniqueId((ItemStack)storageItem, (String)"uuid").map(storageId -> {
                    MovingStorageData.get(storageId).removeStorageContents();
                    return ItemNBTHelper.cleanUpStack(finalStorageItem);
                }).orElse(storageItem);
            }
            ItemStack drop = ((IMovingStorageEntity)this.entity).getDropStack(storageItem);
            if (this.entity.m_8077_()) {
                drop.m_41714_(this.entity.m_7770_());
            }
            this.entity.m_19983_(drop);
        }
    }

    private void dropAllItems() {
        InventoryHelper.dropItems((ItemStackHandler)this.getStorageWrapper().getInventoryHandler(), (Level)this.entity.m_9236_(), (double)this.entity.m_20182_().m_7096_(), (double)this.entity.m_20182_().m_7098_(), (double)this.entity.m_20182_().m_7094_());
        InventoryHelper.dropItems((ItemStackHandler)this.getStorageWrapper().getUpgradeHandler(), (Level)this.entity.m_9236_(), (double)this.entity.m_20182_().m_7096_(), (double)this.entity.m_20182_().m_7098_(), (double)this.entity.m_20182_().m_7094_());
    }

    protected void setLocked(boolean locked) {
        ((IMovingStorageEntity)this.entity).getStorageItem().m_41784_().m_128379_("locked", locked);
    }

    public boolean pack() {
        if (this.isShulkerBox() || this.isPacked(((IMovingStorageEntity)this.entity).getStorageItem())) {
            return false;
        }
        ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        WoodStorageBlockItem.setPacked((ItemStack)storageItem, (boolean)true);
        this.setStorageItem(storageItem);
        return true;
    }

    public void onPlace() {
        if (this.isPacked(((IMovingStorageEntity)this.entity).getStorageItem())) {
            ItemStack storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
            WoodStorageBlockItem.setPacked((ItemStack)storageItem, (boolean)false);
            this.setStorageItem(storageItem);
        }
    }

    private boolean canBeHurtByWithFeedback(DamageSource source) {
        Entity entity;
        if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue() || this.isPacked() || !((entity = source.m_7639_()) instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        if (player.m_6047_() || this.isShulkerBox()) {
            return true;
        }
        AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
        InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
            if (stack.m_41619_()) {
                return;
            }
            droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.m_41613_() / (double)Math.min(stack.m_41741_(), 20)));
        });
        if (droppedItemEntityCount.get() <= (Integer)Config.SERVER.tooManyItemEntityDrops.get()) {
            return true;
        }
        ItemBase packingTapeItem = (ItemBase)ModItems.PACKING_TAPE.get();
        MutableComponent packingTapeItemName = packingTapeItem.m_7626_(new ItemStack((ItemLike)packingTapeItem)).m_6881_().m_130940_(ChatFormatting.GREEN);
        player.m_213846_((Component)StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{this.entity.m_7755_().m_6881_().m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)String.valueOf(droppedItemEntityCount.get())).m_130940_(ChatFormatting.RED), packingTapeItemName}));
        return false;
    }

    public boolean hurt(DamageSource source, float amount, BiFunction<DamageSource, Float, Boolean> superHurt) {
        if (this.canBeHurtByWithFeedback(source) && superHurt.apply(source, Float.valueOf(amount)).booleanValue()) {
            Entity entity = source.m_7639_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_ && this.entity.m_213877_()) {
                    this.dropAllItems();
                }
            }
            return true;
        }
        return false;
    }

    protected AABB getPickupBoundingBox() {
        return this.getEntity().m_20191_().m_82400_(0.2);
    }

    protected void openMenu(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.createMenu(w, pl), this.entity.m_7755_()), buffer -> buffer.writeInt(this.entity.m_19879_()));
        }
    }

    public MovingStorageContainerMenu<? extends Entity> createMenu(int id, Player pl) {
        if (MovingStorageWrapper.isLimitedBarrel((ItemStack)((IMovingStorageEntity)this.entity).getStorageItem())) {
            return new MovingLimitedBarrelContainerMenu(id, pl, this.entity.m_19879_());
        }
        return new MovingStorageContainerMenu(id, pl, this.entity.m_19879_());
    }

    protected void playSound(SoundEvent sound) {
        this.entity.m_9236_().m_6269_(null, this.entity, sound, SoundSource.BLOCKS, 0.5f, this.entity.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    protected void refreshRenderBlockEntity() {
        this.renderBlockEntity = null;
    }
}

