/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.network;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageContentsMessage;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.StorageInMotionPacketHandler;

public class RequestMovingStorageInventoryContentsMessage {
    private final UUID storageUuid;

    public RequestMovingStorageInventoryContentsMessage(UUID storageUuid) {
        this.storageUuid = storageUuid;
    }

    public static void encode(RequestMovingStorageInventoryContentsMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130077_(msg.storageUuid);
    }

    public static RequestMovingStorageInventoryContentsMessage decode(FriendlyByteBuf packetBuffer) {
        return new RequestMovingStorageInventoryContentsMessage(packetBuffer.m_130259_());
    }

    static void onMessage(RequestMovingStorageInventoryContentsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> RequestMovingStorageInventoryContentsMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    public static void handleMessage(@Nullable ServerPlayer player, RequestMovingStorageInventoryContentsMessage msg) {
        Tag upgradeNbt;
        if (player == null) {
            return;
        }
        CompoundTag baseContentsTag = MovingStorageData.get(msg.storageUuid).getContents();
        if (!baseContentsTag.m_128441_("contents")) {
            return;
        }
        CompoundTag contentsTag = baseContentsTag.m_128469_("contents");
        CompoundTag inventoryContents = new CompoundTag();
        Tag inventoryNbt = contentsTag.m_128423_("inventory");
        if (inventoryNbt != null) {
            inventoryContents.m_128365_("inventory", inventoryNbt);
        }
        if ((upgradeNbt = contentsTag.m_128423_("upgradeInventory")) != null) {
            inventoryContents.m_128365_("upgradeInventory", upgradeNbt);
        }
        CompoundTag newBaseContentsTag = new CompoundTag();
        newBaseContentsTag.m_128365_("contents", (Tag)inventoryContents);
        StorageInMotionPacketHandler.INSTANCE.sendToClient(player, new MovingStorageContentsMessage(msg.storageUuid, newBaseContentsTag));
    }
}

