/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;

public class MovingStorageData
extends SavedData
implements IStorageSavedData {
    private static final String SAVED_DATA_PREFIX = "sophisticatedstorageinmotion/";
    private CompoundTag movingStorageContents = new CompoundTag();
    private boolean toRemove = false;
    private static final Map<UUID, MovingStorageData> clientStorageCopy = new HashMap<UUID, MovingStorageData>();
    private final Set<UUID> updatedStorageSettingsFlags = new HashSet<UUID>();

    private MovingStorageData() {
    }

    public static MovingStorageData get(UUID storageId) {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (MovingStorageData)storage.computeIfAbsent(new SavedData.Factory(MovingStorageData::new, MovingStorageData::load), SAVED_DATA_PREFIX + String.valueOf(storageId));
        }
        return clientStorageCopy.computeIfAbsent(storageId, id -> new MovingStorageData());
    }

    public static MovingStorageData load(CompoundTag nbt, HolderLookup.Provider registries) {
        MovingStorageData storageData = new MovingStorageData();
        storageData.movingStorageContents = nbt;
        return storageData;
    }

    public static void moveToItemStorage(ItemStack storageItem, UUID storageId) {
        MovingStorageData storageData = MovingStorageData.get(storageId);
        CompoundTag contents = storageData.getContents();
        contents.put("renderInfo", (Tag)((CustomData)storageItem.getOrDefault(ModCoreDataComponents.RENDER_INFO_TAG, (Object)CustomData.EMPTY)).copyTag());
        CompoundTag fullContents = new CompoundTag();
        fullContents.put("storageWrapper", (Tag)contents);
        ItemContentsStorage.get().setStorageContents(storageId, fullContents);
        storageData.removeStorageContents();
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        if (this.movingStorageContents != null) {
            return this.movingStorageContents;
        }
        return new CompoundTag();
    }

    public void removeStorageContents() {
        this.toRemove = true;
        this.setDirty();
    }

    public void save(File file, HolderLookup.Provider registries) {
        if (this.toRemove) {
            file.delete();
        } else {
            try {
                Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                SophisticatedStorageInMotion.LOGGER.error("Failed to create directories for moving storage data", (Throwable)e);
            }
            super.save(file, registries);
        }
    }

    public void setContents(UUID storageUuid, CompoundTag contents) {
        for (String key : contents.getAllKeys()) {
            this.movingStorageContents.put(key, contents.get(key));
            if (!key.equals("settings")) continue;
            this.updatedStorageSettingsFlags.add(storageUuid);
        }
        this.setDirty();
    }

    public CompoundTag getContents() {
        return this.movingStorageContents;
    }

    public void setContents(CompoundTag contents) {
        this.movingStorageContents = contents;
        this.setDirty();
    }

    public void markChanged() {
        this.setDirty();
    }

    public boolean removeUpdatedStorageSettingsFlag(UUID backpackUuid) {
        return this.updatedStorageSettingsFlags.remove(backpackUuid);
    }
}

