/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageContentsPayload;

public record RequestMovingStorageInventoryContentsPayload(UUID storageUuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestMovingStorageInventoryContentsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedStorageInMotion.getRL("request_moving_storage_inventory_contents"));
    public static final StreamCodec<ByteBuf, RequestMovingStorageInventoryContentsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, RequestMovingStorageInventoryContentsPayload::storageUuid, RequestMovingStorageInventoryContentsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(RequestMovingStorageInventoryContentsPayload payload, IPayloadContext context) {
        Tag upgradeNbt;
        CompoundTag baseContentsTag = MovingStorageData.get().getContents(payload.storageUuid);
        if (!baseContentsTag.contains("contents")) {
            return;
        }
        CompoundTag contentsTag = baseContentsTag.getCompound("contents");
        CompoundTag inventoryContents = new CompoundTag();
        Tag inventoryNbt = contentsTag.get("inventory");
        if (inventoryNbt != null) {
            inventoryContents.put("inventory", inventoryNbt);
        }
        if ((upgradeNbt = contentsTag.get("upgradeInventory")) != null) {
            inventoryContents.put("upgradeInventory", upgradeNbt);
        }
        CompoundTag newBaseContentsTag = new CompoundTag();
        newBaseContentsTag.put("contents", (Tag)inventoryContents);
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MovingStorageContentsPayload(payload.storageUuid, newBaseContentsTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

