/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;

class StaticBlockEntityTintGetter
implements BlockAndTintGetter {
    private final BlockAndTintGetter level;
    private final BlockEntity blockEntity;
    private final int packedLight;

    public StaticBlockEntityTintGetter(BlockAndTintGetter level, BlockEntity blockEntity, int packedLight) {
        this.level = level;
        this.blockEntity = blockEntity;
        this.packedLight = packedLight;
    }

    public float getShade(Direction direction, boolean b) {
        return this.level.getShade(direction, b);
    }

    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        return this.level.getBlockTint(blockPos, colorResolver);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos blockPos) {
        return blockPos == BlockPos.ZERO ? this.blockEntity : this.level.getBlockEntity(blockPos);
    }

    public BlockState getBlockState(BlockPos blockPos) {
        return blockPos == BlockPos.ZERO ? this.blockEntity.getBlockState() : this.level.getBlockState(blockPos);
    }

    public FluidState getFluidState(BlockPos blockPos) {
        return this.level.getFluidState(blockPos);
    }

    public int getHeight() {
        return this.level.getHeight();
    }

    public int getMinY() {
        return this.level.getMinY();
    }

    public int getLightEmission(BlockPos pos) {
        return 0;
    }

    public int getBrightness(LightLayer lightType, BlockPos blockPos) {
        return lightType == LightLayer.SKY ? this.packedLight >> 20 : this.packedLight >> 4 & 0xF;
    }

    public int getRawBrightness(BlockPos blockPos, int amount) {
        int skyValue = this.packedLight >> 20;
        int blockValue = this.packedLight >> 4 & 0xF;
        return Math.max(blockValue, skyValue - amount);
    }
}

