/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class UncraftMovingStorageRecipe
extends CustomRecipe {
    public UncraftMovingStorageRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getMovingStorage(CraftingInput inv) {
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (!(slotStack.getItem() instanceof MovingStorageItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.isEmpty()) {
            return false;
        }
        boolean hasMovingStorage = false;
        for (int slot = 0; slot < input.size(); ++slot) {
            ItemStack slotStack = input.getItem(slot);
            if (!hasMovingStorage && slotStack.getItem() instanceof MovingStorageItem) {
                hasMovingStorage = true;
                continue;
            }
            if (slotStack.isEmpty()) continue;
            return false;
        }
        return hasMovingStorage;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.getMovingStorage(input).map(MovingStorageItem::getStorageItem).orElse(ItemStack.EMPTY);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList remainingItems = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            Item item = slotStack.getItem();
            if (!(item instanceof MovingStorageItem)) continue;
            MovingStorageItem movingStorageItem = (MovingStorageItem)item;
            remainingItems.set(slot, (Object)movingStorageItem.getUncraftRemainingItem(slotStack));
        }
        return remainingItems;
    }

    public RecipeSerializer<UncraftMovingStorageRecipe> getSerializer() {
        return ModItems.UNCRAFT_MOVING_STORAGE_SERIALIZER.get();
    }
}

