/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageTierUpgradeShapedRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageTierUpgradeRecipesMaker {
    private MovingStorageTierUpgradeRecipesMaker() {
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<RecipeHolder<CraftingRecipe>> getShapedCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return MovingStorageTierUpgradeRecipesMaker.getShapedCraftingRecipes(getSubtypeInterpreter, RecipeHolder::new);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapedCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        RecipeConstructor<MovingStorageTierUpgradeShapedRecipe> constructRecipe = (originalRecipe, ingredients, result) -> {
            ShapedRecipePattern pattern = new ShapedRecipePattern(originalRecipe.getWidth(), originalRecipe.getHeight(), ingredients, Optional.empty());
            return new ShapedRecipe("", CraftingBookCategory.MISC, pattern, result);
        };
        return MovingStorageTierUpgradeRecipesMaker.getCraftingRecipes(constructRecipe, MovingStorageTierUpgradeShapedRecipe.class, getSubtypeInterpreter, transformRecipe);
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<RecipeHolder<CraftingRecipe>> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return MovingStorageTierUpgradeRecipesMaker.getShapelessCraftingRecipes(getSubtypeInterpreter, RecipeHolder::new);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        RecipeConstructor<MovingStorageTierUpgradeShapelessRecipe> constructRecipe = (originalRecipe, ingredients, result) -> new ShapelessRecipe("", CraftingBookCategory.MISC, result, ingredients);
        return MovingStorageTierUpgradeRecipesMaker.getCraftingRecipes(constructRecipe, MovingStorageTierUpgradeShapelessRecipe.class, getSubtypeInterpreter, transformRecipe);
    }

    private static <R, T extends CraftingRecipe, U extends PropertyBasedSubtypeInterpreter> List<R> getCraftingRecipes(RecipeConstructor<T> constructRecipe, Class<T> originalRecipeClass, Function<ItemStack, Optional<U>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        return ClientRecipeHelper.transformAllRecipesOfTypeIntoMultiple((RecipeType)RecipeType.CRAFTING, originalRecipeClass, recipe -> {
            ArrayList itemGroupRecipes = new ArrayList();
            MovingStorageTierUpgradeRecipesMaker.getStorageItems(recipe).forEach(storageItem -> {
                NonNullList ingredients = recipe.getIngredients();
                TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                    public ItemStack quickMoveStack(Player player, int index) {
                        return ItemStack.EMPTY;
                    }

                    public boolean stillValid(Player playerIn) {
                        return false;
                    }
                }, 3, 3);
                NonNullList ingredientsCopy = NonNullList.createWithCapacity((int)ingredients.size());
                List<Object> baseMovingStorageItems = Collections.emptyList();
                int movingStorageIngredientIndex = -1;
                int i = 0;
                for (Ingredient ingredient : ingredients) {
                    Item patt0$temp;
                    ItemStack[] ingredientItems = ingredient.getItems();
                    if (ingredientItems.length > 0 && (patt0$temp = ingredientItems[0].getItem()) instanceof MovingStorageItem) {
                        MovingStorageItem movingStorageItem = (MovingStorageItem)patt0$temp;
                        baseMovingStorageItems = movingStorageItem.getBaseMovingStorageItems();
                        movingStorageIngredientIndex = i;
                    } else if (!ingredient.isEmpty()) {
                        craftinginventory.setItem(i, ingredientItems[0]);
                    }
                    ingredientsCopy.add(i, (Object)ingredient);
                    ++i;
                }
                for (ItemStack movingStorage : baseMovingStorageItems) {
                    itemGroupRecipes.add(MovingStorageTierUpgradeRecipesMaker.createMovingStorageTierUpgradeRecipe(constructRecipe, recipe, storageItem, movingStorage, (NonNullList<Ingredient>)ingredientsCopy, movingStorageIngredientIndex, (CraftingContainer)craftinginventory, getSubtypeInterpreter, transformRecipe));
                }
            });
            return itemGroupRecipes;
        });
    }

    private static <R, T extends CraftingRecipe, U extends PropertyBasedSubtypeInterpreter> R createMovingStorageTierUpgradeRecipe(RecipeConstructor<T> constructRecipe, T recipe, ItemStack storageItem, ItemStack movingStorage, NonNullList<Ingredient> ingredients, int movingStorageIngredientIndex, CraftingContainer craftinginventory, Function<ItemStack, Optional<U>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        MovingStorageItem.setStorageItem(movingStorage, storageItem);
        NonNullList ingredientsCopy = NonNullList.createWithCapacity((int)ingredients.size());
        ingredientsCopy.addAll(ingredients);
        ingredientsCopy.set(movingStorageIngredientIndex, (Object)Ingredient.of((ItemStack[])new ItemStack[]{movingStorage}));
        craftinginventory.setItem(movingStorageIngredientIndex, movingStorage.copy());
        ItemStack result = ClientRecipeHelper.assemble(recipe, (RecipeInput)craftinginventory.asCraftInput());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorageinmotion", (String)("tier_upgrade_" + getSubtypeInterpreter.apply(storageItem).map(interpreter -> interpreter.getRegistrySanitizedItemString(storageItem)).orElse("") + "_to_" + getSubtypeInterpreter.apply(result).map(interpreter -> interpreter.getRegistrySanitizedItemString(result)).orElse("")));
        return transformRecipe.apply(id, constructRecipe.construct(recipe, (NonNullList<Ingredient>)ingredientsCopy, result));
    }

    private static List<ItemStack> getStorageItems(CraftingRecipe recipe) {
        NonNullList storageItems = NonNullList.create();
        for (Ingredient ingredient : recipe.getIngredients()) {
            ItemStack[] ingredientItems;
            for (ItemStack ingredientItem : ingredientItems = ingredient.getItems()) {
                Item item = ingredientItem.getItem();
                if (!(item instanceof MovingStorageItem) || !(MovingStorageItem.getStorageItem(ingredientItem).getItem() instanceof StorageBlockItem)) continue;
                storageItems.add((Object)MovingStorageItem.getStorageItem(ingredientItem));
            }
        }
        return storageItems;
    }

    private static interface RecipeConstructor<T extends Recipe<?>> {
        public CraftingRecipe construct(T var1, NonNullList<Ingredient> var2, ItemStack var3);
    }
}

