/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.IClientHighlightHandler;
import net.p3pp3rf1y.sophisticatedcore.client.render.ItemInStorageHighlightRenderer;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.MovingStorageItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;

public class MovingStorageHighlightHandler
implements IClientHighlightHandler<List<Integer>> {
    public static final MovingStorageHighlightHandler INSTANCE = new MovingStorageHighlightHandler();
    private List<Integer> highlightedStackEntityIds = Collections.emptyList();
    private List<Integer> highlightedItemEntityIds = Collections.emptyList();

    private MovingStorageHighlightHandler() {
    }

    public void setHighlightedEntities(List<Integer> stackEntityIds, List<Integer> itemEntityIds) {
        this.highlightedStackEntityIds = stackEntityIds;
        this.highlightedItemEntityIds = itemEntityIds;
    }

    public ResourceLocation getPayloadHandlerId() {
        return MovingStorageItemActionPayloadHandler.ID;
    }

    public List<Integer> buildClientRequestData(Player player) {
        return player.m_9236_().m_6249_((Entity)player, player.m_20191_().m_82400_(32.0), e -> e instanceof IMovingStorageEntity && e.m_20270_((Entity)player) <= 32.0f).stream().map(Entity::m_19879_).toList();
    }

    public void clearCache() {
        this.highlightedStackEntityIds = Collections.emptyList();
        this.highlightedItemEntityIds = Collections.emptyList();
    }

    public void render(PoseStack poseStack, float partialTick, Vec3 cameraPos) {
        this.highlightedStackEntityIds.forEach(eId -> MovingStorageHighlightHandler.renderHighlightedEntity(poseStack, partialTick, cameraPos, eId, Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_(), 5025616));
        this.highlightedItemEntityIds.forEach(eId -> MovingStorageHighlightHandler.renderHighlightedEntity(poseStack, partialTick, cameraPos, eId, Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_(), 4367861));
    }

    private static void renderHighlightedEntity(PoseStack poseStack, float partialTick, Vec3 cameraPos, int entityId, Minecraft mc, MultiBufferSource.BufferSource buffer, int color) {
        Entity entity = mc.f_91073_.m_6815_(entityId);
        if (entity == null) {
            return;
        }
        AABB boundingBox = entity.m_20191_();
        double x = Mth.m_14139_((double)partialTick, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTick, (double)entity.f_19791_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)partialTick, (double)entity.f_19792_, (double)entity.m_20189_());
        poseStack.m_85836_();
        double halfH = boundingBox.m_82376_() * 0.5;
        poseStack.m_85837_(x - cameraPos.m_7096_(), y - cameraPos.m_7098_(), z - cameraPos.m_7094_());
        poseStack.m_85837_(0.0, halfH, 0.0);
        float scale = 1.0f + Easing.EASE_IN_OUT_CUBIC.ease((float)ItemInStorageHighlightRenderer.tri01((double)mc.f_91073_.m_46467_(), (double)15.0, (double)partialTick)) * 0.05f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(0.0, -halfH, 0.0);
        BlockHighlightRenderHelper.renderThickEdges((PoseStack)poseStack, (MultiBufferSource)buffer, (int)color, (List)VoxelOutliner.edgesFromAABB((AABB)boundingBox), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_());
        poseStack.m_85849_();
    }
}

