/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;

public record OpenMovingStorageInventoryMessage(int entityId) {
    public static void encode(OpenMovingStorageInventoryMessage msg, ByteBuf buffer) {
        buffer.writeInt(msg.entityId());
    }

    public static OpenMovingStorageInventoryMessage decode(ByteBuf buffer) {
        return new OpenMovingStorageInventoryMessage(buffer.readInt());
    }

    static void onMessage(OpenMovingStorageInventoryMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> OpenMovingStorageInventoryMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    public static void handleMessage(@Nullable ServerPlayer player, OpenMovingStorageInventoryMessage payload) {
        if (player == null) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(payload.entityId());
        if (entity instanceof IMovingStorageEntity) {
            IMovingStorageEntity storageEntity = (IMovingStorageEntity)entity;
            storageEntity.getStorageHolder().openContainerMenu((Player)player);
        }
    }
}

