/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.StorageBlockRenderer;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageBoat;
import org.joml.Quaternionf;

public class StorageBoatRenderer
extends EntityRenderer<StorageBoat> {
    private final BoatRenderer boatRenderer;

    public StorageBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.boatRenderer = new BoatRenderer(context, false);
    }

    public ResourceLocation getTextureLocation(StorageBoat storageBoat) {
        return (ResourceLocation)this.boatRenderer.getModelWithLocation((Boat)storageBoat).getFirst();
    }

    public void render(StorageBoat storageBoat, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float bubbleAngle;
        super.render((Entity)storageBoat, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.pushPose();
        poseStack.translate(0.0f, storageBoat.getVariant().isRaft() ? 0.5f : 0.1875f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float interpolatedHurtTime = (float)storageBoat.getHurtTime() - partialTicks;
        float interpolatedDamage = storageBoat.getDamage() - partialTicks;
        if (interpolatedDamage < 0.0f) {
            interpolatedDamage = 0.0f;
        }
        if (interpolatedHurtTime > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)interpolatedHurtTime) * interpolatedHurtTime * interpolatedDamage / 10.0f * (float)storageBoat.getHurtDir()));
        }
        if (!Mth.equal((float)(bubbleAngle = storageBoat.getBubbleAngle(partialTicks)), (float)0.0f)) {
            poseStack.mulPose(new Quaternionf().setAngleAxis(storageBoat.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.scale(0.85714287f, 0.85714287f, 0.85714287f);
        StorageBlockEntity renderBlockEntity = storageBoat.getStorageHolder().getRenderBlockEntity();
        poseStack.translate(-0.5f, 0.0f, (renderBlockEntity instanceof BarrelBlockEntity || renderBlockEntity instanceof ShulkerBoxBlockEntity ? 0.0f : 0.0625f) + 0.02f);
        StorageBlockRenderer.renderStorageBlock(partialTicks, poseStack, buffer, packedLight, renderBlockEntity);
        poseStack.popPose();
        this.boatRenderer.render((Boat)storageBoat, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

