/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.compat.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.CraftingContainerRecipeTransferHandlerBase;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.SettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.StorageGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui.MovingStorageScreen;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui.MovingStorageSettingsScreen;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.compat.jei.AssembleRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorageinmotion.compat.jei.MovingStorageSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorageinmotion.compat.jei.MovingStorageTierUpgradeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.StorageBoatItem;

@JeiPlugin
public class StorageInMotionPlugin
implements IModPlugin {
    private Map<Item, PropertyBasedSubtypeInterpreter> getSubtypeInterpreters() {
        return new HashMap<Item, PropertyBasedSubtypeInterpreter>(){
            {
                this.put((Item)ModItems.STORAGE_MINECART.get(), new MovingStorageSubtypeInterpreter());
                this.put((Item)ModItems.STORAGE_BOAT.get(), new StorageBoatSubtypeInterpreter());
            }
        };
    }

    private Optional<PropertyBasedSubtypeInterpreter> getSubtypeInterpreter(Map<Item, PropertyBasedSubtypeInterpreter> subtypeInterpreters, ItemStack stack) {
        return Optional.ofNullable(subtypeInterpreters.get(stack.getItem()));
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorageinmotion", (String)"default");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        this.getSubtypeInterpreters().forEach((arg_0, arg_1) -> ((ISubtypeRegistration)registration).registerSubtypeInterpreter(arg_0, arg_1));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(MovingStorageScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<MovingStorageScreen>(this){

            public List<Rect2i> getGuiExtraAreas(MovingStorageScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                gui.getUpgradeSlotsRectangle().ifPresent(ret::add);
                ret.addAll(gui.getUpgradeSettingsControl().getTabRectangles());
                gui.getSortButtonsRectangle().ifPresent(ret::add);
                ret.add(gui.getHorseControlRectangle());
                return ret;
            }
        });
        registration.addGuiContainerHandler(MovingStorageSettingsScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<MovingStorageSettingsScreen>(this){

            public List<Rect2i> getGuiExtraAreas(MovingStorageSettingsScreen gui) {
                return new ArrayList<Rect2i>(gui.getSettingsTabControl().getTabRectangles());
            }
        });
        registration.addGhostIngredientHandler(MovingStorageScreen.class, (IGhostIngredientHandler)new StorageGhostIngredientHandler());
        registration.addGhostIngredientHandler(MovingStorageSettingsScreen.class, (IGhostIngredientHandler)new SettingsGhostIngredientHandler());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Map<Item, PropertyBasedSubtypeInterpreter> subtypeInterpreters = this.getSubtypeInterpreters();
        registration.addRecipes(RecipeTypes.CRAFTING, AssembleRecipesMaker.getShapelessCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (ItemStack)stack)));
        registration.addRecipes(RecipeTypes.CRAFTING, MovingStorageTierUpgradeRecipesMaker.getShapedCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (ItemStack)stack)));
        registration.addRecipes(RecipeTypes.CRAFTING, MovingStorageTierUpgradeRecipesMaker.getShapelessCraftingRecipes(stack -> this.getSubtypeInterpreter(subtypeInterpreters, (ItemStack)stack)));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingContainerRecipeTransferHandlerBase<MovingStorageContainerMenu<?>, RecipeHolder<CraftingRecipe>>(this, handlerHelper, stackHelper){

            public Class<MovingStorageContainerMenu<?>> getContainerClass() {
                return MovingStorageContainerMenu.class;
            }

            public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
                return RecipeTypes.CRAFTING;
            }
        }, RecipeTypes.CRAFTING);
    }

    private static class StorageBoatSubtypeInterpreter
    extends MovingStorageSubtypeInterpreter {
        public StorageBoatSubtypeInterpreter() {
            this.addOptionalProperty(boatStack -> Optional.of(StorageBoatItem.getBoatType(boatStack)), "boatType", boatType -> boatType.name().toLowerCase(Locale.ROOT));
        }
    }
}

