/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageMinecart;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;
import org.jetbrains.annotations.Nullable;

public class StorageMinecartItem
extends MovingStorageItem {
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource blockSource, ItemStack stack) {
            double slopeOffset;
            RailShape railshape;
            BlockPos blockpos;
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel serverlevel = blockSource.level();
            BlockState blockstate = serverlevel.getBlockState(blockpos = blockSource.pos().relative(direction));
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baseRailBlock = (BaseRailBlock)block;
                v0 = baseRailBlock.getRailDirection(blockstate, (BlockGetter)serverlevel, blockpos, null);
            } else {
                v0 = railshape = RailShape.NORTH_SOUTH;
            }
            if (blockstate.is(BlockTags.RAILS)) {
                slopeOffset = railshape.isAscending() ? 0.6 : 0.1;
            } else {
                RailShape railShape;
                if (!blockstate.isAir() || !serverlevel.getBlockState(blockpos.below()).is(BlockTags.RAILS)) {
                    return this.defaultDispenseItemBehavior.dispense(blockSource, stack);
                }
                BlockState stateBelow = serverlevel.getBlockState(blockpos.below());
                Block block2 = stateBelow.getBlock();
                if (block2 instanceof BaseRailBlock) {
                    BaseRailBlock baseRailBlock = (BaseRailBlock)block2;
                    railShape = baseRailBlock.getRailDirection(stateBelow, (BlockGetter)serverlevel, blockpos.below(), null);
                } else {
                    railShape = RailShape.NORTH_SOUTH;
                }
                RailShape railShapeBelow = railShape;
                slopeOffset = direction != Direction.DOWN && railShapeBelow.isAscending() ? -0.4 : -0.9;
            }
            serverlevel.addFreshEntity((Entity)StorageMinecartItem.createMinecart(serverlevel, blockpos, slopeOffset, stack, null));
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource blockSource) {
            blockSource.level().levelEvent(1000, blockSource.pos(), 0);
        }
    };

    public StorageMinecartItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            RailShape railShape;
            ServerLevel serverlevel = (ServerLevel)level;
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baseRailBlock = (BaseRailBlock)block;
                railShape = baseRailBlock.getRailDirection(blockstate, (BlockGetter)level, blockpos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double ascendingOffset = 0.0;
            if (railshape.isAscending()) {
                ascendingOffset = 0.5;
            }
            Player player = context.getPlayer();
            serverlevel.addFreshEntity((Entity)StorageMinecartItem.createMinecart(serverlevel, blockpos, ascendingOffset, stack, player));
            serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)serverlevel.getBlockState(blockpos.below())));
        }
        stack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static StorageMinecart createMinecart(ServerLevel serverlevel, BlockPos blockpos, double ascendingOffset, ItemStack stack, @Nullable Player player) {
        StorageMinecart minecart = new StorageMinecart((Level)serverlevel, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.0625 + ascendingOffset, (double)blockpos.getZ() + 0.5);
        EntityStorageHolder<?> storageHolder = minecart.getStorageHolder();
        storageHolder.setStorageItemFromMovingStorage(stack, true);
        storageHolder.onPlace();
        EntityType.createDefaultStackConfig((ServerLevel)serverlevel, (ItemStack)stack, (Player)player).accept(minecart);
        return minecart;
    }

    @Override
    public ItemStack getUncraftRemainingItem(ItemStack input) {
        return new ItemStack((ItemLike)Items.MINECART);
    }
}

