/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.mixin;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractChestedHorse.class})
public abstract class MixinAbstractChestedHorse
extends AbstractHorse
implements IMovingStorageEntity {
    private static final String STORAGE_HOLDER_TAG = "storageHolder";
    @Unique
    private final EntityStorageHolder<MixinAbstractChestedHorse> entityStorageHolder = new EntityStorageHolder<MixinAbstractChestedHorse>(this);
    @Unique
    private static final EntityDataAccessor<ItemStack> DATA_STORAGE_ITEM = SynchedEntityData.defineId(MixinAbstractChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    @Shadow
    public abstract boolean hasChest();

    protected MixinAbstractChestedHorse(EntityType<? extends AbstractChestedHorse> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    protected abstract void playChestEquipsSound();

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedStorageItem(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(DATA_STORAGE_ITEM, (Object)ItemStack.EMPTY);
    }

    @Inject(method={"dropEquipment"}, at={@At(value="TAIL")})
    private void dropStorageAndItsContents(CallbackInfo ci) {
        this.entityStorageHolder.onDestroy();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addStorageHolderSaveData(CompoundTag tag, CallbackInfo ci) {
        if (this.hasStorageItem()) {
            tag.put(STORAGE_HOLDER_TAG, (Tag)this.entityStorageHolder.saveData((HolderLookup.Provider)this.level().registryAccess()));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readStorageHolderSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.contains(STORAGE_HOLDER_TAG)) {
            this.entityStorageHolder.readData((HolderLookup.Provider)this.level().registryAccess(), tag.getCompound(STORAGE_HOLDER_TAG));
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isTamed() && stack.getItem() instanceof StorageBlockItem && !this.hasStorageItem() && !this.hasChest()) {
            ItemStack stackCopy = stack.copyWithCount(1);
            this.entityStorageHolder.setStorageItemFrom(stackCopy, true);
            this.playChestEquipsSound();
            stack.consume(1, (LivingEntity)player);
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)this.level().isClientSide));
        } else if (this.isTamed() && this.hasStorageItem() && stack.is(Items.CHEST)) {
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Override
    public List<Slot> instantiateExtraSlots() {
        if (this.canUseSlot(EquipmentSlot.BODY)) {
            return List.of(new ArmorSlot(this.getBodyArmorAccess(), (LivingEntity)this, EquipmentSlot.BODY, 0, 8, 36, null){

                public boolean mayPlace(ItemStack stack) {
                    return MixinAbstractChestedHorse.this.isBodyArmorItem(stack);
                }
            });
        }
        if (this.isSaddleable()) {
            return List.of(new Slot(this.getInventory(), 0, 0, 0){

                public boolean mayPlace(ItemStack stack) {
                    return stack.is(Items.SADDLE) && !this.hasItem() && MixinAbstractChestedHorse.this.isSaddleable();
                }
            });
        }
        return Collections.emptyList();
    }

    private boolean hasStorageItem() {
        return !this.getStorageItem().isEmpty();
    }

    @Override
    public ItemStack getStorageItem() {
        return (ItemStack)this.entityData.get(DATA_STORAGE_ITEM);
    }

    @Override
    public void setStorageItem(ItemStack storageItem) {
        this.entityData.set(DATA_STORAGE_ITEM, (Object)storageItem.copy());
    }

    @Override
    public EntityStorageHolder<?> getStorageHolder() {
        return this.entityStorageHolder;
    }

    @Override
    public ItemStack getDropStack(ItemStack storageItem) {
        @Nullable UUID storageId = (UUID)storageItem.get(ModCoreDataComponents.STORAGE_UUID);
        if (storageId != null) {
            MovingStorageData.moveToItemStorage(storageItem, storageId);
        }
        return storageItem;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == DATA_STORAGE_ITEM && this.level().isClientSide()) {
            this.entityStorageHolder.onStorageItemSynced();
        }
    }

    public void tick() {
        super.tick();
        this.entityStorageHolder.tick((Entity)this);
    }
}

