/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderTierUpgradeHandler;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageMinecart;
import org.apache.logging.log4j.util.Supplier;

public class TierUpgradeHandler {
    private static final Map<StorageTierUpgradeItem.TierUpgrade, Map<Item, IEntityTierUpgradeDefinition>> ENTITY_TIER_UPGRADE_DEFINITIONS = new HashMap<StorageTierUpgradeItem.TierUpgrade, Map<Item, IEntityTierUpgradeDefinition>>();

    private TierUpgradeHandler() {
    }

    public static void onTierUpgradeInteract(PlayerInteractEvent.EntityInteract event) {
        IMovingStorageEntity movingStorage;
        Player player = event.getEntity();
        ItemStack itemInHand = player.getItemInHand(event.getHand());
        Item item = itemInHand.getItem();
        if (!(item instanceof StorageTierUpgradeItem)) {
            return;
        }
        StorageTierUpgradeItem tierUpgradeItem = (StorageTierUpgradeItem)item;
        Map<Item, IEntityTierUpgradeDefinition> tierDefinitions = ENTITY_TIER_UPGRADE_DEFINITIONS.get(tierUpgradeItem.getTier());
        if (tierDefinitions == null) {
            SophisticatedStorageInMotion.LOGGER.warn("No tier upgrade definitions found for {}", (Object)tierUpgradeItem.getTier());
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof IMovingStorageEntity && !(movingStorage = (IMovingStorageEntity)entity).getStorageHolder().isOpen() && !movingStorage.getStorageHolder().isPacked()) {
            TierUpgradeHandler.upgradeEntity(event, event.getTarget(), player, itemInHand, tierDefinitions, movingStorage.getStorageItem().getItem(), movingStorage.getStorageItem());
        } else {
            entity = event.getTarget();
            if (entity instanceof MinecartChest) {
                MinecartChest minecartChest = (MinecartChest)entity;
                TierUpgradeHandler.upgradeEntity(event, (Entity)minecartChest, player, itemInHand, tierDefinitions, Items.CHEST, ItemStack.EMPTY);
            }
        }
    }

    private static void upgradeEntity(PlayerInteractEvent.EntityInteract event, Entity entity, Player player, ItemStack tierUpgrade, Map<Item, IEntityTierUpgradeDefinition> tierDefinitions, Item tierDefinitionItem, ItemStack storageItem) {
        IEntityTierUpgradeDefinition upgradeDefinition = tierDefinitions.get(tierDefinitionItem);
        if (upgradeDefinition == null) {
            SophisticatedStorageInMotion.LOGGER.warn("No tier upgrade definition found for {}", new Supplier[]{() -> BuiltInRegistries.ITEM.getKey((Object)tierDefinitionItem)});
            return;
        }
        if (!player.level().isClientSide()) {
            upgradeDefinition.upgradeEntity(entity, storageItem);
            if (!player.isCreative()) {
                tierUpgrade.shrink(1);
            }
        }
        event.setCanceled(true);
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
    }

    static {
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC, Map.of(Items.CHEST, new VanillaMinecartChestTierUpgradeDefinition((BlockItem)ModBlocks.CHEST_ITEM.get())));
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_COPPER, EntityTierUpgradeMap.builder().put(Items.CHEST, new VanillaMinecartChestTierUpgradeDefinition((BlockItem)ModBlocks.COPPER_CHEST_ITEM.get())).putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_COPPER)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_IRON, EntityTierUpgradeMap.builder().put(Items.CHEST, new VanillaMinecartChestTierUpgradeDefinition((BlockItem)ModBlocks.IRON_CHEST_ITEM.get())).putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_IRON)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_GOLD, EntityTierUpgradeMap.builder().put(Items.CHEST, new VanillaMinecartChestTierUpgradeDefinition((BlockItem)ModBlocks.GOLD_CHEST_ITEM.get())).putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_GOLD)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_DIAMOND, EntityTierUpgradeMap.builder().put(Items.CHEST, new VanillaMinecartChestTierUpgradeDefinition((BlockItem)ModBlocks.DIAMOND_CHEST_ITEM.get())).putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_DIAMOND)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_NETHERITE, EntityTierUpgradeMap.builder().put(Items.CHEST, new VanillaMinecartChestTierUpgradeDefinition((BlockItem)ModBlocks.NETHERITE_CHEST_ITEM.get())).putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.BASIC_TO_NETHERITE)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_IRON, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_IRON)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_GOLD, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_GOLD)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_DIAMOND, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_DIAMOND)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_NETHERITE, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.COPPER_TO_NETHERITE)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.IRON_TO_GOLD, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.IRON_TO_GOLD)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.IRON_TO_DIAMOND, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.IRON_TO_DIAMOND)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.IRON_TO_NETHERITE, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.IRON_TO_NETHERITE)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.GOLD_TO_DIAMOND, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.GOLD_TO_DIAMOND)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.GOLD_TO_NETHERITE, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.GOLD_TO_NETHERITE)).build());
        ENTITY_TIER_UPGRADE_DEFINITIONS.put(StorageTierUpgradeItem.TierUpgrade.DIAMOND_TO_NETHERITE, EntityTierUpgradeMap.builder().putAllWrapped((Map)StorageHolderTierUpgradeHandler.STORAGE_HOLDER_TIER_UPGRADE_DEFINITIONS.get(StorageTierUpgradeItem.TierUpgrade.DIAMOND_TO_NETHERITE)).build());
    }

    static interface IEntityTierUpgradeDefinition {
        public void upgradeEntity(Entity var1, ItemStack var2);
    }

    private static class VanillaMinecartChestTierUpgradeDefinition
    implements IEntityTierUpgradeDefinition {
        private final BlockItem upgradedItem;

        private VanillaMinecartChestTierUpgradeDefinition(BlockItem upgradedItem) {
            this.upgradedItem = upgradedItem;
        }

        @Override
        public void upgradeEntity(Entity entity, ItemStack storageItem) {
            if (!(entity instanceof MinecartChest)) {
                return;
            }
            MinecartChest minecartChest = (MinecartChest)entity;
            StorageMinecart storageMinecart = new StorageMinecart(minecartChest.level(), minecartChest.getX(), minecartChest.getY(), minecartChest.getZ());
            storageMinecart.getStorageHolder().setStorageItem(WoodStorageBlockItem.setWoodType((ItemStack)new ItemStack((ItemLike)this.upgradedItem), (WoodType)WoodType.OAK));
            InventoryHandler inventoryHandler = storageMinecart.getStorageHolder().getStorageWrapper().getInventoryHandler();
            for (int slot = 0; slot < minecartChest.getContainerSize(); ++slot) {
                inventoryHandler.setStackInSlot(slot, minecartChest.getItem(slot));
                minecartChest.setItem(slot, ItemStack.EMPTY);
            }
            minecartChest.discard();
            minecartChest.level().addFreshEntity((Entity)storageMinecart);
        }
    }

    private static class EntityTierUpgradeMap {
        private final ImmutableMap.Builder<Item, IEntityTierUpgradeDefinition> wrappedBuilder = ImmutableMap.builder();

        private EntityTierUpgradeMap() {
        }

        public static EntityTierUpgradeMap builder() {
            return new EntityTierUpgradeMap();
        }

        public EntityTierUpgradeMap put(Item item, IEntityTierUpgradeDefinition definition) {
            this.wrappedBuilder.put((Object)item, (Object)definition);
            return this;
        }

        public EntityTierUpgradeMap putAllWrapped(Map<Item, StorageHolderTierUpgradeHandler.StorageHolderUpgradeDefinition> storageHolderDefinitions) {
            storageHolderDefinitions.forEach((item, definition) -> this.wrappedBuilder.put(item, (Object)new EntityTierUpgradeDefinition((StorageHolderTierUpgradeHandler.StorageHolderUpgradeDefinition)definition)));
            return this;
        }

        public Map<Item, IEntityTierUpgradeDefinition> build() {
            return this.wrappedBuilder.build();
        }
    }

    private static class EntityTierUpgradeDefinition
    implements IEntityTierUpgradeDefinition {
        private final StorageHolderTierUpgradeHandler.StorageHolderUpgradeDefinition storageHolderDefinition;

        private EntityTierUpgradeDefinition(StorageHolderTierUpgradeHandler.StorageHolderUpgradeDefinition storageHolderDefinition) {
            this.storageHolderDefinition = storageHolderDefinition;
        }

        @Override
        public void upgradeEntity(Entity entity, ItemStack storageItem) {
            if (!(entity instanceof IMovingStorageEntity)) {
                return;
            }
            IMovingStorageEntity movingStorage = (IMovingStorageEntity)entity;
            EntityStorageHolder<?> storageHolder = movingStorage.getStorageHolder();
            this.storageHolderDefinition.upgradeStorageHolder(storageHolder, storageItem);
        }
    }
}

