/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageMinecart;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class StorageMinecartItem
extends MovingStorageItem {
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource blockSource, ItemStack stack) {
            double slopeOffset;
            BlockPos blockpos;
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel serverlevel = blockSource.level();
            BlockState blockstate = serverlevel.getBlockState(blockpos = blockSource.pos().relative(direction));
            if (blockstate.is(BlockTags.RAILS)) {
                slopeOffset = 1.getRailShape(blockstate, serverlevel, blockpos).isSlope() ? 0.6 : 0.1;
            } else {
                if (!blockstate.isAir()) {
                    return this.defaultDispenseItemBehavior.dispense(blockSource, stack);
                }
                BlockState blockstate1 = serverlevel.getBlockState(blockpos.below());
                if (!blockstate1.is(BlockTags.RAILS)) {
                    return this.defaultDispenseItemBehavior.dispense(blockSource, stack);
                }
                slopeOffset = direction != Direction.DOWN && 1.getRailShape(blockstate1, serverlevel, blockpos.below()).isSlope() ? -0.4 : -0.9;
            }
            serverlevel.addFreshEntity((Entity)StorageMinecartItem.createMinecart(serverlevel, blockpos, slopeOffset, stack, null));
            stack.shrink(1);
            return stack;
        }

        private static RailShape getRailShape(BlockState state, ServerLevel level, BlockPos pos) {
            RailShape railShape;
            Block block = state.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baserailblock = (BaseRailBlock)block;
                railShape = baserailblock.getRailDirection(state, (BlockGetter)level, pos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            return railShape;
        }

        protected void playSound(BlockSource blockSource) {
            blockSource.level().levelEvent(1000, blockSource.pos(), 0);
        }
    };

    public StorageMinecartItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            RailShape railShape;
            ServerLevel serverlevel = (ServerLevel)level;
            Block block = blockstate.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock baseRailBlock = (BaseRailBlock)block;
                railShape = baseRailBlock.getRailDirection(blockstate, (BlockGetter)level, blockpos, null);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            double ascendingOffset = 0.0;
            if (railshape.isSlope()) {
                ascendingOffset = 0.5;
            }
            Player player = context.getPlayer();
            serverlevel.addFreshEntity((Entity)StorageMinecartItem.createMinecart(serverlevel, blockpos, ascendingOffset, stack, player));
            serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)serverlevel.getBlockState(blockpos.below())));
        }
        stack.shrink(1);
        return InteractionResult.SUCCESS;
    }

    private static StorageMinecart createMinecart(ServerLevel serverlevel, BlockPos blockpos, double ascendingOffset, ItemStack stack, @Nullable Player player) {
        StorageMinecart minecart = new StorageMinecart((Level)serverlevel, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.0625 + ascendingOffset, (double)blockpos.getZ() + 0.5);
        EntityStorageHolder<?> storageHolder = minecart.getStorageHolder();
        storageHolder.setStorageItemFromMovingStorage(stack, true);
        storageHolder.onPlace();
        EntityType.createDefaultStackConfig((Level)serverlevel, (ItemStack)stack, (Player)player).accept(minecart);
        return minecart;
    }

    @Override
    public ItemStack getUncraftRemainingItem(ItemStack input) {
        return new ItemStack((ItemLike)Items.MINECART);
    }
}

