/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageIngredient
extends AbstractIngredient {
    private final Holder<Item> storageItem;
    private final Holder<? extends Item> movingStorageItem;

    private MovingStorageIngredient(Holder<? extends Item> movingStorageItem, Holder<Item> storageItem) {
        super(MovingStorageIngredient.getMovingStorageStacks(movingStorageItem, storageItem));
        this.storageItem = storageItem;
        this.movingStorageItem = movingStorageItem;
    }

    private static Stream<? extends Ingredient.Value> getMovingStorageStacks(Holder<? extends Item> movingStorageItem, Holder<Item> storageItem) {
        ArrayList storageItemCreativeTabItems = new ArrayList();
        Object object = storageItem.m_203334_();
        if (object instanceof BlockItemBase) {
            BlockItemBase itemBase = (BlockItemBase)object;
            itemBase.addCreativeTabItems(storageItemCreativeTabItems::add);
        }
        ArrayList movingStorages = new ArrayList();
        storageItemCreativeTabItems.forEach(storageItemStack -> {
            ItemStack movingStorageStack = new ItemStack((ItemLike)movingStorageItem.get());
            MovingStorageItem.setStorageItem(movingStorageStack, storageItemStack);
            movingStorages.add(movingStorageStack);
        });
        ItemStack[] movingStorageStacks = movingStorages.toArray(new ItemStack[0]);
        return Stream.of(movingStorageStacks).map(Ingredient.ItemValue::new);
    }

    public static MovingStorageIngredient of(Holder<? extends Item> movingStorageItem, Item storageItem) {
        return new MovingStorageIngredient(movingStorageItem, (Holder<Item>)((Holder)ForgeRegistries.ITEMS.getHolder(ForgeRegistries.ITEMS.getKey((Object)storageItem)).orElseThrow()));
    }

    public boolean test(@Nullable ItemStack itemStack) {
        return itemStack != null && itemStack.m_41720_() == this.movingStorageItem.get() && MovingStorageItem.getStorageItem(itemStack).m_41720_() == this.storageItem.m_203334_();
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("movingStorageItem", ForgeRegistries.ITEMS.getKey((Object)((Item)this.movingStorageItem.m_203334_())).toString());
        json.addProperty("storageItem", ForgeRegistries.ITEMS.getKey((Object)((Item)this.storageItem.m_203334_())).toString());
        return json;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<MovingStorageIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public MovingStorageIngredient parse(FriendlyByteBuf buffer) {
            return new MovingStorageIngredient(this.fromRegistryName(buffer.m_130277_()), this.fromRegistryName(buffer.m_130277_()));
        }

        public MovingStorageIngredient parse(JsonObject json) {
            return new MovingStorageIngredient(this.fromRegistryName(json.get("movingStorageItem").getAsString()), this.fromRegistryName(json.get("storageItem").getAsString()));
        }

        public void write(FriendlyByteBuf buffer, MovingStorageIngredient ingredient) {
            buffer.m_130070_(ForgeRegistries.ITEMS.getKey((Object)((Item)ingredient.movingStorageItem.m_203334_())).toString());
            buffer.m_130070_(ForgeRegistries.ITEMS.getKey((Object)((Item)ingredient.storageItem.m_203334_())).toString());
        }

        private Holder<Item> fromRegistryName(String registryName) {
            return (Holder)ForgeRegistries.ITEMS.getHolder(new ResourceLocation(registryName)).orElseThrow();
        }
    }
}

