/*
 * Decompiled with CFR 0.152.
 */
package net.purejosh.pureberries.block;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9062;
import net.purejosh.pureberries.block.entity.MortarBlockEntity;
import net.purejosh.pureberries.recipe.MortarRecipeManager;
import net.purejosh.pureberries.sound.ModSoundEvents;
import net.purejosh.pureberries.world.ModGameRules;
import org.jetbrains.annotations.Nullable;

public class MortarBlock
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2383.field_11177;
    private static final class_265 SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0);
    private final int maxDurability;

    public MortarBlock(class_4970.class_2251 settings, int maxDurability) {
        super(settings);
        this.maxDurability = maxDurability;
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
        if (!this.method_9558(state, (class_4538)ctx.method_8045(), ctx.method_8037())) {
            return null;
        }
        return state;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 below = pos.method_10074();
        if (!world.method_8320(below).method_26206((class_1922)world, below, class_2350.field_11036)) {
            return false;
        }
        return super.method_9558(state, world, pos);
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11033 && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MortarBlockEntity(pos, state);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_9062.method_55644((boolean)false);
        }
        class_1799 held = player.method_5998(hand);
        List<class_1799> outputs = MortarRecipeManager.getOutputsFor(held.method_7909());
        if (outputs.isEmpty()) {
            return super.method_55765(stack, state, world, pos, player, hand, hit);
        }
        this.grind(world, pos, player, held, outputs);
        return class_9062.method_55644((boolean)true);
    }

    private void grind(class_1937 world, class_2338 pos, class_1657 player, class_1799 held, List<class_1799> outputs) {
        if (!player.method_7337()) {
            held.method_7934(1);
        }
        for (class_1799 class_17992 : outputs) {
            if (class_17992.method_7960()) continue;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 0.33;
            double z = (double)pos.method_10260() + 0.5;
            class_1542 entity = new class_1542(world, x, y, z, class_17992.method_7972());
            double speed = 0.05;
            entity.method_18800((world.field_9229.method_43058() - 0.5) * speed, world.field_9229.method_43058() * 0.15, (world.field_9229.method_43058() - 0.5) * speed);
            entity.method_6982(10);
            world.method_8649((class_1297)entity);
        }
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 s = (class_3218)class_19372;
            s.method_8396(null, pos, ModSoundEvents.MORTAR_USE, class_3419.field_15245, 0.3f, 1.3f);
            s.method_8396(null, pos, ModSoundEvents.MORTAR_PLANT, class_3419.field_15245, 1.0f, 0.5f);
            s.method_14199((class_2394)class_2398.field_17741, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.35, (double)pos.method_10260() + 0.5, 3, 0.1, 0.02, 0.1, 1.0);
        }
        world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)world.method_8320(pos)));
        player.method_7259(class_3468.field_15372.method_14956((Object)held.method_7909()));
        class_2586 be = world.method_8321(pos);
        if (be instanceof MortarBlockEntity) {
            MortarBlockEntity mortarBlockEntity = (MortarBlockEntity)be;
            if (world.method_8450().method_8355(ModGameRules.MORTAR_DURABILITY)) {
                mortarBlockEntity.decrementDurability();
                mortarBlockEntity.method_5431();
            }
        }
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236 && player.method_7337()) {
            world.method_8544(pos);
        }
        super.method_9576(world, pos, state, player);
        return state;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204()) {
            MortarBlockEntity mortar;
            class_2586 be = world.method_8321(pos);
            if (be instanceof MortarBlockEntity && (mortar = (MortarBlockEntity)be).getDurability() > 0) {
                class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
                class_1792 mortarItem = (class_1792)class_7923.field_41178.method_10223(id);
                class_1799 drop = new class_1799((class_1935)mortarItem);
                int damage = this.maxDurability - mortar.getDurability();
                drop.method_7974(damage);
                class_1542 entity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, drop);
                entity.method_6982(10);
                world.method_8649((class_1297)entity);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        if (world.field_9236) {
            return;
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof MortarBlockEntity)) {
            return;
        }
        MortarBlockEntity mortar = (MortarBlockEntity)be;
        int used = class_3532.method_15340((int)stack.method_7919(), (int)0, (int)this.maxDurability);
        mortar.setDurability(this.maxDurability - used);
        mortar.method_5431();
        world.method_8413(pos, state, state, 2);
    }
}

