/*
 * Decompiled with CFR 0.152.
 */
package net.purejosh.pureberries.entity.effect;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_4081;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.purejosh.pureberries.PureBerries;
import net.purejosh.pureberries.entity.effect.ModStatusEffects;
import net.purejosh.pureberries.sound.ModSoundEvents;
import net.purejosh.pureberries.world.ModGameRules;

public class NimbusStatusEffect
extends class_1291 {
    public static final Set<UUID> NIMBUS_FINAL_PARTICLE = ConcurrentHashMap.newKeySet();
    private static final class_2960 GRAVITY_ID = PureBerries.id("nimbus_gravity");
    private static final class_2960 SAFE_FALL_ID = PureBerries.id("nimbus_safe_fall");
    private static final class_2960 FALL_DMG_ID = PureBerries.id("nimbus_fall_damage");

    public NimbusStatusEffect(class_4081 category, int color) {
        super(category, color);
    }

    public void method_52520(class_1309 e, int amp) {
        class_1937 class_19372;
        class_3222 p;
        block5: {
            block4: {
                if (!(e instanceof class_3222)) break block4;
                p = (class_3222)e;
                class_19372 = e.method_37908();
                if (class_19372 instanceof class_3218) break block5;
            }
            return;
        }
        class_3218 world = (class_3218)class_19372;
        float nimbusStrength = (float)world.method_8450().method_8356(ModGameRules.NIMBUS_STRENGTH) / 100.0f;
        if (nimbusStrength == 0.0f) {
            return;
        }
        NimbusStatusEffect.safeAddModifier(p.method_5996(class_5134.field_49078), GRAVITY_ID, Math.max(-0.065 * (double)nimbusStrength, -0.07), class_1322.class_1323.field_6328);
        NimbusStatusEffect.safeAddModifier(p.method_5996(class_5134.field_49079), SAFE_FALL_ID, (float)(3 * (amp + 1) + 3) * nimbusStrength, class_1322.class_1323.field_6328);
        NimbusStatusEffect.safeAddModifier(p.method_5996(class_5134.field_49077), FALL_DMG_ID, Math.max(-0.1 * (double)(amp + 1) * (double)nimbusStrength, -0.8), class_1322.class_1323.field_6328);
    }

    public void method_58617(class_1309 e, int amp, class_1297.class_5529 r) {
        NIMBUS_FINAL_PARTICLE.remove(e.method_5667());
        NimbusStatusEffect.safeRemoveModifier(e.method_5996(class_5134.field_49078), GRAVITY_ID);
        NimbusStatusEffect.safeRemoveModifier(e.method_5996(class_5134.field_49079), SAFE_FALL_ID);
        NimbusStatusEffect.safeRemoveModifier(e.method_5996(class_5134.field_49077), FALL_DMG_ID);
        super.method_58617(e, amp, r);
    }

    public void method_5562(class_5131 attribute) {
        NimbusStatusEffect.safeRemoveModifier(attribute.method_45329(class_5134.field_49078), GRAVITY_ID);
        NimbusStatusEffect.safeRemoveModifier(attribute.method_45329(class_5134.field_49079), SAFE_FALL_ID);
        NimbusStatusEffect.safeRemoveModifier(attribute.method_45329(class_5134.field_49077), FALL_DMG_ID);
        super.method_5562(attribute);
    }

    public boolean method_5572(class_1309 e, int amp) {
        class_1324 grav;
        boolean hasGrav;
        boolean missingFD;
        class_1937 class_19372;
        class_3222 p;
        block14: {
            block13: {
                if (!(e instanceof class_3222)) break block13;
                p = (class_3222)e;
                class_19372 = e.method_37908();
                if (class_19372 instanceof class_3218) break block14;
            }
            return true;
        }
        class_3218 world = (class_3218)class_19372;
        class_1324 sfInst = p.method_5996(class_5134.field_49079);
        class_1324 fdInst = p.method_5996(class_5134.field_49077);
        boolean missingSF = sfInst == null || sfInst.method_6199(SAFE_FALL_ID) == null;
        boolean bl = missingFD = fdInst == null || fdInst.method_6199(FALL_DMG_ID) == null;
        if (p.method_6059(ModStatusEffects.NIMBUS) && (missingSF || missingFD)) {
            this.method_52520(e, amp);
        }
        boolean bl2 = hasGrav = (grav = p.method_5996(class_5134.field_49078)) != null && grav.method_6199(GRAVITY_ID) != null;
        if (p.method_31549().field_7479 || p.method_6128()) {
            if (hasGrav) {
                NimbusStatusEffect.safeRemoveModifier(grav, GRAVITY_ID);
                PureBerries.devLogging(e, "Flying: removed gravity modifier");
            }
            return true;
        }
        UUID id = p.method_5667();
        boolean flagged = NIMBUS_FINAL_PARTICLE.contains(id);
        double effectFall = p.method_45325(class_5134.field_49079) - 3.0;
        double fall = e.field_6017;
        if (p.method_24828()) {
            if (hasGrav) {
                NimbusStatusEffect.safeRemoveModifier(grav, GRAVITY_ID);
                PureBerries.devLogging(e, "Landed: removed gravity modifier");
            }
            if (flagged) {
                NIMBUS_FINAL_PARTICLE.remove(id);
                PureBerries.devLogging(e, "Landed: cleared end-particle flag");
            }
            return true;
        }
        if (fall >= effectFall) {
            if (hasGrav) {
                NimbusStatusEffect.safeRemoveModifier(grav, GRAVITY_ID);
                PureBerries.devLogging(e, String.format("Threshold crossed (%.2f >= %.2f): removed gravity", fall, effectFall));
            }
            if (!flagged) {
                NIMBUS_FINAL_PARTICLE.add(id);
                NimbusStatusEffect.nimbusEffectEndingParticle(e, world);
                PureBerries.devLogging(e, String.format("Threshold crossed (%.2f >= %.2f): spawned end particle", fall, effectFall));
            }
            return true;
        }
        if (!hasGrav) {
            float str = (float)world.method_8503().method_3767().method_8356(ModGameRules.NIMBUS_STRENGTH) / 100.0f;
            NimbusStatusEffect.safeAddModifier(grav, GRAVITY_ID, Math.max(-0.065 * (double)str, -0.07), class_1322.class_1323.field_6328);
            PureBerries.devLogging(e, "Nimbus floating: gravity applied");
        }
        NimbusStatusEffect.nimbusEffectParticles(e, world);
        PureBerries.devLogging(e, String.format("Nimbus floating: %.2f blocks fallen", fall));
        return true;
    }

    private static void nimbusEffectParticles(class_1309 entity, class_3218 serverWorld) {
        for (int i = 0; i < 3; ++i) {
            double offsetX = (entity.method_59922().method_43058() - 0.5) * ((double)entity.method_17681() * 1.2);
            double offsetZ = (entity.method_59922().method_43058() - 0.5) * ((double)entity.method_17681() * 1.2);
            serverWorld.method_14199((class_2394)class_2398.field_50252, entity.method_23317() + offsetX, entity.method_23318() - 0.8, entity.method_23321() + offsetZ, 1, 0.0, 0.1, 0.0, 10.0);
        }
        if (serverWorld.method_8510() % 8L == 0L) {
            float pitch = 1.8f + entity.method_59922().method_43057() * 0.2f;
            for (int i = 0; i < 3; ++i) {
                serverWorld.method_47967(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), ModSoundEvents.NIMBUS_WHIRL, class_3419.field_15248, 1.0f, pitch, 1L);
            }
        }
    }

    private static void nimbusEffectEndingParticle(class_1309 entity, class_3218 serverWorld) {
        serverWorld.method_14199((class_2394)class_2398.field_47494, entity.method_23317(), entity.method_23318() - 1.0, entity.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        serverWorld.method_47967(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), ModSoundEvents.NIMBUS_END, class_3419.field_15248, 0.2f, 1.6f + entity.method_59922().method_43057() * 0.2f, 1L);
    }

    private static void safeAddModifier(class_1324 attribute, class_2960 id, double value, class_1322.class_1323 operation) {
        if (attribute == null) {
            PureBerries.LOGGER.error("[NimbusStatusEffect] safeAddModifier: Attribute instance is null for modifier {}. This is unexpected. If this caused a crash, please notify the developer with full logs.", (Object)id);
            return;
        }
        class_1322 existing = attribute.method_6199(id);
        if (existing != null) {
            PureBerries.LOGGER.error("[NimbusStatusEffect] safeAddModifier: Modifier {} is already applied on attribute {}. This is unexpected. If this caused a crash, please notify the developer with full logs.", (Object)id, (Object)attribute.method_6198().method_55840());
            return;
        }
        try {
            attribute.method_26835(new class_1322(id, value, operation));
        }
        catch (RuntimeException e) {
            PureBerries.LOGGER.error("[NimbusStatusEffect] safeAddModifier: Exception while adding modifier {} (value: {}, operation: {}) to attribute {}. This is unexpected. If this caused a crash, please notify the developer with full logs.", (Object)id, (Object)value, (Object)operation, (Object)attribute.method_6198().method_55840(), (Object)e);
        }
    }

    private static void safeRemoveModifier(class_1324 attribute, class_2960 id) {
        if (attribute == null) {
            PureBerries.LOGGER.error("[NimbusStatusEffect] safeRemoveModifier: Attribute instance is null for modifier {}. This is unexpected. If this caused a crash, please notify the developer with full logs.", (Object)id);
            return;
        }
        if (attribute.method_6199(id) == null) {
            return;
        }
        try {
            attribute.method_6200(id);
        }
        catch (RuntimeException e) {
            PureBerries.LOGGER.error("[NimbusStatusEffect] safeRemoveModifier: Exception while removing modifier {} from attribute {}. If this caused a crash, please notify the developer with full logs.", (Object)id, (Object)attribute.method_6198().method_55840(), (Object)e);
        }
    }

    public boolean method_5552(int duration, int amplifier) {
        return true;
    }
}

