/*
 * Decompiled with CFR 0.152.
 */
package net.purejosh.pureberries.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class GoldenBerryItem
extends class_1792 {
    private final class_6880<class_1291> effect;
    private final class_1928.class_4313<class_1928.class_4312> strengthRule;
    private final int duration;
    private final int maxAmplifier;

    public GoldenBerryItem(class_1792.class_1793 settings, class_6880<class_1291> effect, class_1928.class_4313<class_1928.class_4312> strengthRule, int duration, int maxAmplifier) {
        super(settings);
        this.effect = effect;
        this.duration = duration;
        this.maxAmplifier = maxAmplifier;
        this.strengthRule = strengthRule;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        MinecraftServer server;
        class_1799 itemStack = super.method_7861(stack, world, user);
        if (world.field_9236) {
            return itemStack;
        }
        if (user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            class_174.field_1198.method_8821(serverPlayer, stack);
            serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
        if ((server = world.method_8503()) != null) {
            int strength = server.method_3767().method_8356(this.strengthRule);
            if (strength == 0) {
                return itemStack;
            }
            class_1293 current = user.method_6112(this.effect);
            int newAmp = current == null ? 0 : Math.min(current.method_5578() + 1, this.maxAmplifier);
            int newDuration = this.duration * (newAmp + 1);
            user.method_6092(new class_1293(this.effect, newDuration, newAmp));
        }
        return itemStack;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && client.field_1687.method_8450().method_8356(this.strengthRule) == 0) {
            return;
        }
        String effectName = ((class_1291)this.effect.comp_349()).method_5560().getString();
        int totalSeconds = this.duration / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        String timeFormatted = String.format(" (%d:%02d)", minutes, seconds);
        tooltip.add((class_2561)class_2561.method_30163((String)(effectName + timeFormatted)).method_27661().method_27694(style -> style.method_10977(class_124.field_1078)));
        if (class_437.method_25442()) {
            String effectId = Objects.requireNonNull(class_7923.field_41174.method_10221((Object)((class_1291)this.effect.comp_349()))).method_12832();
            String descKey = "item.pureberries.golden_berries." + effectId + ".tooltip";
            String rawDesc = class_1074.method_4662((String)descKey, (Object[])new Object[0]);
            for (String line : rawDesc.split("\n")) {
                tooltip.add((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.pureberries.hold").method_27694(style -> style.method_10977(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" [")).method_10852((class_2561)class_2561.method_43471((String)"item.pureberries.shift").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"] ")).method_10852((class_2561)class_2561.method_43471((String)"item.pureberries.for_info").method_27692(class_124.field_1063)));
        }
        super.method_7851(stack, context, tooltip, type);
    }
}

