/*
 * Decompiled with CFR 0.152.
 */
package net.hollowed.combatamenities.mixin.slots.rendering;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.hollowed.combatamenities.config.CAConfig;
import net.hollowed.combatamenities.util.items.CAComponents;
import net.minecraft.class_10799;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class HudRendererMixin {
    @Shadow
    @Final
    private class_310 field_2035;
    @Unique
    private static final class_2960 WIDGETS_TEXTURE = class_2960.method_60654((String)"textures/gui/sprites/hud/hotbar_offhand_left.png");
    @Unique
    private static class_1799 lastBackSlotStack = class_1799.field_8037;
    @Unique
    private static class_1799 lastBeltSlotStack = class_1799.field_8037;
    @Unique
    private int animationTicks = 0;

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (this.animationTicks > 0) {
            --this.animationTicks;
        }
    }

    @Inject(method={"renderHotbar"}, at={@At(value="TAIL")})
    public void renderHotbar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        this.renderBackSlot(context, tickCounter);
        this.renderBeltSlot(context, tickCounter);
    }

    @Unique
    private void renderBeltSlot(class_332 drawContext, class_9779 tickCounter) {
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity != null) {
            class_1799 beltSlotStack = playerEntity.method_31548().method_5438(42);
            if (!class_1799.method_7973((class_1799)beltSlotStack, (class_1799)lastBeltSlotStack) && this.animationTicks == 0) {
                lastBeltSlotStack = beltSlotStack.method_7972();
                if (((String)beltSlotStack.method_58695(CAComponents.STRING_PROPERTY, (Object)"")).equals("bob5")) {
                    this.animationTicks = 5;
                }
            }
            if (((String)beltSlotStack.method_58695(CAComponents.STRING_PROPERTY, (Object)"")).equals("bob5")) {
                beltSlotStack.method_57381(CAComponents.STRING_PROPERTY);
            }
            if (!beltSlotStack.method_7960()) {
                int x = HudRendererMixin.getBeltX(drawContext);
                int y = drawContext.method_51443() - CAConfig.backslotY - 4;
                RenderSystem.assertOnRenderThread();
                GlStateManager._enableBlend();
                drawContext.method_25290(class_10799.field_56883, WIDGETS_TEXTURE, x + 1, y - 19, 0.0f, 0.0f, 22, 23, 29, 24);
                this.renderItem(drawContext, x + 4, y - 15, tickCounter, (class_1657)playerEntity, beltSlotStack);
            }
        }
    }

    @Unique
    private void renderBackSlot(class_332 drawContext, class_9779 tickCounter) {
        class_746 playerEntity = class_310.method_1551().field_1724;
        if (playerEntity != null) {
            class_1799 backSlotStack = playerEntity.method_31548().method_5438(41);
            if (!class_1799.method_7973((class_1799)backSlotStack, (class_1799)lastBackSlotStack) && this.animationTicks == 0) {
                lastBackSlotStack = backSlotStack.method_7972();
                if (((String)backSlotStack.method_58695(CAComponents.STRING_PROPERTY, (Object)"")).equals("bob5")) {
                    this.animationTicks = 5;
                }
            }
            if (((String)backSlotStack.method_58695(CAComponents.STRING_PROPERTY, (Object)"")).equals("bob5")) {
                backSlotStack.method_57381(CAComponents.STRING_PROPERTY);
            }
            if (!backSlotStack.method_7960()) {
                int x = HudRendererMixin.getX(drawContext);
                int y = drawContext.method_51443() - CAConfig.backslotY - 4;
                RenderSystem.assertOnRenderThread();
                GlStateManager._disableBlend();
                drawContext.method_25290(class_10799.field_56883, WIDGETS_TEXTURE, x + 1, y - 19, 0.0f, 0.0f, 22, 23, 29, 24);
                this.renderItem(drawContext, x + 4, y - 15, tickCounter, (class_1657)playerEntity, backSlotStack);
            }
        }
    }

    @Unique
    private void renderItem(class_332 context, int x, int y, class_9779 tickCounter, class_1657 player, class_1799 stack) {
        if (!stack.method_7960()) {
            float f = (float)this.animationTicks - tickCounter.method_60637(false);
            if (f > 0.0f) {
                float g = 1.0f + f / 5.0f;
                context.method_51448().pushMatrix();
                context.method_51448().translate((float)(x + 8), (float)(y + 12));
                context.method_51448().scale(1.0f / g, (g + 1.0f) / 2.0f);
                context.method_51448().translate((float)(-(x + 8)), (float)(-(y + 12)));
            }
            context.method_51423((class_1309)player, stack, x, y, 1);
            if (f > 0.0f) {
                context.method_51448().popMatrix();
            }
            context.method_51431(this.field_2035.field_1772, stack, x, y);
        }
    }

    @Unique
    private static int getX(class_332 drawContext) {
        boolean isLeftHanded = ((class_1306)class_310.method_1551().field_1690.method_42552().method_41753()).equals((Object)class_1306.field_6182);
        int x = isLeftHanded ? drawContext.method_51421() / 2 - CAConfig.backslotX - 120 : drawContext.method_51421() / 2 + CAConfig.backslotX + 97;
        return x;
    }

    @Unique
    private static int getBeltX(class_332 drawContext) {
        boolean isLeftHanded = ((class_1306)class_310.method_1551().field_1690.method_42552().method_41753()).equals((Object)class_1306.field_6182);
        int x = isLeftHanded ? drawContext.method_51421() / 2 - CAConfig.backslotX - 143 : drawContext.method_51421() / 2 + CAConfig.backslotX + 120;
        return x;
    }
}

