/*
 * Decompiled with CFR 0.152.
 */
package net.hollowed.combatamenities.mixin.tweaks.enchantments;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.hollowed.combatamenities.CombatAmenities;
import net.hollowed.combatamenities.config.CAConfig;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9889;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1890.class})
public abstract class EnchantmentHelperMixin {
    @Shadow
    public static void method_8231(List<class_1889> possibleEntries, class_1889 pickedEntry) {
    }

    @Unique
    private static List<class_1889> getPossibleEntries(int level, class_1799 stack, Stream<class_6880<class_1887>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        boolean bl = stack.method_31574(class_1802.field_8529);
        possibleEnchantments.filter(enchantment -> ((class_1887)enchantment.comp_349()).method_58444(stack) || bl).forEach(enchantmentx -> {
            class_1887 enchantment = (class_1887)enchantmentx.comp_349();
            for (int j = enchantment.method_8183(); j >= enchantment.method_8187(); --j) {
                if (level < enchantment.method_8182(j) || level > enchantment.method_20742(j)) continue;
                list.add(new class_1889(enchantmentx, j));
                break;
            }
        });
        list.removeIf(entry -> EnchantmentHelperMixin.isDisallowedEnchantment(((class_1887)entry.comp_3486().comp_349()).toString()));
        return list;
    }

    @Inject(method={"generateEnchantments"}, at={@At(value="HEAD")}, cancellable=true)
    private static void filterGeneratedEnchantments(class_5819 random, class_1799 stack, int level, Stream<class_6880<class_1887>> possibleEnchantments, CallbackInfoReturnable<List<class_1889>> cir) {
        ArrayList list = Lists.newArrayList();
        class_9889 enchantableComponent = (class_9889)stack.method_58694(class_9334.field_53695);
        if (enchantableComponent == null) {
            cir.setReturnValue((Object)list);
        } else {
            level += 1 + random.method_43048(enchantableComponent.comp_2938() / 4 + 1) + random.method_43048(enchantableComponent.comp_2938() / 4 + 1);
            float f = (random.method_43057() + random.method_43057() - 1.0f) * 0.15f;
            List<class_1889> list2 = EnchantmentHelperMixin.getPossibleEntries(level = class_3532.method_15340((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), stack, possibleEnchantments);
            if (!list2.isEmpty()) {
                class_6011.method_34986((class_5819)random, list2, class_1889::method_66344).ifPresent(list::add);
                while (random.method_43048(50) <= level) {
                    if (!list.isEmpty()) {
                        EnchantmentHelperMixin.method_8231(list2, (class_1889)class_156.method_20793((List)list));
                    }
                    if (list2.isEmpty()) break;
                    class_6011.method_34986((class_5819)random, list2, class_1889::method_66344).ifPresent(list::add);
                    level /= 2;
                }
            }
            cir.setReturnValue((Object)list);
        }
    }

    @Unique
    private static boolean isDisallowedEnchantment(String enchantment) {
        return CAConfig.removeDurability && CombatAmenities.DURABILITY_ENCHANTMENTS.contains(enchantment) || CAConfig.builtInLoyalty && CombatAmenities.TRIDENT_ENCHANTMENTS.contains(enchantment);
    }
}

