/*
 * Decompiled with CFR 0.152.
 */
package net.hollowed.combatamenities.mixin.tweaks.enchantments;

import java.util.stream.IntStream;
import net.hollowed.combatamenities.CombatAmenities;
import net.hollowed.combatamenities.config.CAConfig;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net.minecraft.item.ItemGroups"})
public abstract class ItemGroupMixin {
    @Inject(method={"addMaxLevelEnchantedBooks"}, at={@At(value="HEAD")}, cancellable=true)
    private static void filterMaxLevelBooks(class_1761.class_7704 entries, class_7225<class_1887> registryWrapper, class_1761.class_7705 stackVisibility, CallbackInfo ci) {
        registryWrapper.method_42017().map(enchantmentEntry -> class_1890.method_61711((class_1889)new class_1889((class_6880)enchantmentEntry, ((class_1887)enchantmentEntry.comp_349()).method_8183()))).filter(ItemGroupMixin::isAllowedBook).forEach(stack -> entries.method_45417(stack, stackVisibility));
        ci.cancel();
    }

    @Inject(method={"addAllLevelEnchantedBooks"}, at={@At(value="HEAD")}, cancellable=true)
    private static void filterAllLevelBooks(class_1761.class_7704 entries, class_7225<class_1887> registryWrapper, class_1761.class_7705 stackVisibility, CallbackInfo ci) {
        registryWrapper.method_42017().flatMap(enchantmentEntry -> IntStream.rangeClosed(((class_1887)enchantmentEntry.comp_349()).method_8187(), ((class_1887)enchantmentEntry.comp_349()).method_8183()).mapToObj(level -> class_1890.method_61711((class_1889)new class_1889((class_6880)enchantmentEntry, level)))).filter(ItemGroupMixin::isAllowedBook).forEach(stack -> entries.method_45417(stack, stackVisibility));
        ci.cancel();
    }

    @Unique
    private static boolean isAllowedBook(class_1799 stack) {
        return class_1890.method_57532((class_1799)stack).method_57534().stream().noneMatch(enchantment -> {
            String id = ((class_1887)enchantment.comp_349()).toString();
            return ItemGroupMixin.isDisallowedEnchantment(id);
        });
    }

    @Unique
    private static boolean isDisallowedEnchantment(String enchantment) {
        return CAConfig.removeDurability && CombatAmenities.DURABILITY_ENCHANTMENTS.contains(enchantment) || CAConfig.builtInLoyalty && CombatAmenities.TRIDENT_ENCHANTMENTS.contains(enchantment);
    }
}

