/*
 * Decompiled with CFR 0.152.
 */
package net.hollowed.combatamenities.util.json;

import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hollowed.combatamenities.CombatAmenities;
import net.hollowed.combatamenities.util.delay.ClientTickDelayScheduler;
import net.hollowed.combatamenities.util.json.BeltTransformData;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.slf4j.Logger;

public class BeltTransformResourceReloadListener
implements class_4013 {
    private static final Map<class_2960, BeltTransformData> transforms = new HashMap<class_2960, BeltTransformData>();
    private static BeltTransformData defaultTransforms;

    public void method_14491(class_3300 manager) {
        class_310.method_1551().execute(() -> this.actuallyLoad(manager));
    }

    private void actuallyLoad(class_3300 manager) {
        ClientTickDelayScheduler.schedule(-1, () -> {
            transforms.clear();
            manager.method_14488("beltslot_transforms", path -> path.method_12832().endsWith(".json")).keySet().forEach(id -> {
                if (manager.method_14486(id).isPresent()) {
                    try (InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();){
                        JsonObject json = class_3518.method_15255((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                        DataResult result = BeltTransformData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                        result.resultOrPartial(arg_0 -> ((Logger)CombatAmenities.LOGGER).error(arg_0)).ifPresent(data -> {
                            if (data.item().equals("default")) {
                                defaultTransforms = data;
                            } else if (data.item().startsWith("#")) {
                                String tagString = data.item().substring(1);
                                class_2960 tagId = class_2960.method_60654((String)tagString);
                                class_6862 tag = class_6862.method_40092((class_5321)class_7923.field_41178.method_46765(), (class_2960)tagId);
                                if (tag != null) {
                                    class_7923.field_41178.forEach(item -> {
                                        class_2960 itemId = class_7923.field_41178.method_10221(item);
                                        if (item.method_7854().method_41409().method_40220(tag)) {
                                            transforms.putIfAbsent(itemId, (BeltTransformData)data);
                                        }
                                    });
                                } else {
                                    CombatAmenities.LOGGER.warn("Tag #{} not found while loading item transforms!", (Object)tagId);
                                }
                            } else {
                                transforms.put(class_2960.method_60654((String)data.item()), (BeltTransformData)data);
                            }
                        });
                    }
                    catch (Exception e) {
                        CombatAmenities.LOGGER.error("Failed to load transform for {}: {}", id, (Object)e.getMessage());
                    }
                }
            });
        });
    }

    public static BeltTransformData getTransform(class_2960 itemId, String component) {
        BeltTransformData baseTransform = transforms.getOrDefault(itemId, defaultTransforms);
        if (baseTransform != null) {
            if (baseTransform.componentTransforms().containsKey(component)) {
                BeltTransformData.SubTransformData subTransform = baseTransform.componentTransforms().get(component);
                BeltTransformData.SecondaryTransformData secondary = subTransform.secondaryTransforms();
                BeltTransformData.TertiaryTransformData tertiary = subTransform.tertiaryTransforms();
                return new BeltTransformData(itemId.toString(), subTransform.scale(), subTransform.rotation(), subTransform.translation(), subTransform.mode(), subTransform.sway(), Map.of(), subTransform.flip(), new BeltTransformData.SecondaryTransformData(secondary.item(), secondary.scale(), secondary.rotation(), secondary.translation(), secondary.mode()), new BeltTransformData.TertiaryTransformData(tertiary.item(), tertiary.scale(), tertiary.rotation(), tertiary.translation(), tertiary.mode()));
            }
            return baseTransform;
        }
        return new BeltTransformData(itemId.toString(), List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)), List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)), List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)), class_811.field_4319, Float.valueOf(1.0f), Map.of(), false, new BeltTransformData.SecondaryTransformData(class_2960.method_60654((String)"null"), List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)), List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)), List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)), class_811.field_4319), new BeltTransformData.TertiaryTransformData(class_2960.method_60654((String)"null"), List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)), List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)), List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)), class_811.field_4319));
    }
}

