/*
 * Decompiled with CFR 0.152.
 */
package net.hollowed.combatamenities.util.delay;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.hollowed.combatamenities.util.delay.DelayHandler;

public class ClientTickDelayScheduler {
    public static final Map<Integer, DelayHandler> scheduledTasks = new ConcurrentHashMap<Integer, DelayHandler>();
    private static int taskIdCounter = 0;
    public static boolean run = false;

    public static int schedule(int ticks, Runnable task) {
        int taskId = taskIdCounter++;
        scheduledTasks.put(taskId, new DelayHandler(ticks, task, taskId));
        return taskId;
    }

    public static void tick() {
        if (!scheduledTasks.isEmpty()) {
            for (int i = 0; i < scheduledTasks.size(); ++i) {
                DelayHandler handler = scheduledTasks.values().stream().toList().get(i);
                if (handler.ticks == -1) {
                    if (!run) continue;
                    handler.task.run();
                    scheduledTasks.remove(handler.id);
                    if (!scheduledTasks.isEmpty()) continue;
                    break;
                }
                if (handler.ticks > 0) {
                    --handler.ticks;
                    continue;
                }
                handler.task.run();
                scheduledTasks.remove(handler.id);
                if (scheduledTasks.isEmpty()) break;
            }
        }
    }

    public static void cancel(int taskId) {
        scheduledTasks.remove(taskId);
    }
}

